/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.http;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

@ConfigurationProperties(prefix="citrus.simulator.rest")
public class SimulatorRestConfigurationProperties
implements EnvironmentAware {
    private static Logger log = LoggerFactory.getLogger(SimulatorRestConfigurationProperties.class);
    private static final String SIMULATOR_URL_MAPPING_PROPERTY = "citrus.simulator.rest.url.mapping";
    private static final String SIMULATOR_URL_MAPPING_ENV = "CITRUS_SIMULATOR_REST_URL_MAPPING";
    private boolean enabled = true;
    private String urlMapping = "/services/rest/**";
    private Environment env;

    @PostConstruct
    private void loadProperties() {
        this.urlMapping = this.env.getProperty(SIMULATOR_URL_MAPPING_PROPERTY, this.env.getProperty(SIMULATOR_URL_MAPPING_ENV, this.urlMapping));
        log.info("Using the simulator configuration: {}", (Object)this.toString());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getUrlMapping() {
        return this.urlMapping;
    }

    public void setUrlMapping(String urlMapping) {
        this.urlMapping = urlMapping;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{enabled='" + this.enabled + '\'' + ", urlMapping='" + this.urlMapping + '\'' + '}';
    }

    public void setEnvironment(Environment environment) {
        this.env = environment;
    }
}

