/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.jms;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

@ConfigurationProperties(prefix="citrus.simulator.jms")
public class SimulatorJmsConfigurationProperties
implements EnvironmentAware {
    private static Logger log = LoggerFactory.getLogger(SimulatorJmsConfigurationProperties.class);
    private static final String SIMULATOR_INBOUND_DESTINATION_PROPERTY = "citrus.simulator.jms.inbound.destination";
    private static final String SIMULATOR_INBOUND_DESTINATION_ENV = "CITRUS_SIMULATOR_JMS_INBOUND_DESTINATION";
    private static final String SIMULATOR_REPLY_DESTINATION_PROPERTY = "citrus.simulator.jms.reply.destination";
    private static final String SIMULATOR_REPLY_DESTINATION_ENV = "CITRUS_SIMULATOR_JMS_REPLY_DESTINATION";
    private static final String SIMULATOR_SYNC_PROPERTY = "citrus.simulator.jms.synchronous";
    private static final String SIMULATOR_SYNC_ENV = "CITRUS_SIMULATOR_JMS_SYNCHRONOUS";
    private static final String SIMULATOR_SOAP_ENVELOPE_PROPERTY = "citrus.simulator.jms.soap";
    private static final String SIMULATOR_SOAP_ENVELOPE_ENV = "CITRUS_SIMULATOR_JMS_SOAP";
    private static final String SIMULATOR_PUB_SUB_DOMAIN_PROPERTY = "citrus.simulator.jms.pub.sub.domain";
    private static final String SIMULATOR_PUB_SUB_DOMAIN_ENV = "CITRUS_SIMULATOR_JMS_PUB_SUB_DOMAIN";
    private boolean enabled;
    private String inboundDestination = "Citrus.Simulator.Inbound";
    private String replyDestination = "";
    private boolean synchronous = false;
    private boolean useSoap = false;
    private boolean pubSubDomain = false;
    private Environment env;

    @PostConstruct
    private void loadProperties() {
        this.inboundDestination = this.env.getProperty(SIMULATOR_INBOUND_DESTINATION_PROPERTY, this.env.getProperty(SIMULATOR_INBOUND_DESTINATION_ENV, this.inboundDestination));
        this.replyDestination = this.env.getProperty(SIMULATOR_REPLY_DESTINATION_PROPERTY, this.env.getProperty(SIMULATOR_REPLY_DESTINATION_ENV, this.replyDestination));
        this.synchronous = Boolean.valueOf(this.env.getProperty(SIMULATOR_SYNC_PROPERTY, this.env.getProperty(SIMULATOR_SYNC_ENV, String.valueOf(this.synchronous))));
        this.useSoap = Boolean.valueOf(this.env.getProperty(SIMULATOR_SOAP_ENVELOPE_PROPERTY, this.env.getProperty(SIMULATOR_SOAP_ENVELOPE_ENV, String.valueOf(this.useSoap))));
        this.pubSubDomain = Boolean.valueOf(this.env.getProperty(SIMULATOR_PUB_SUB_DOMAIN_PROPERTY, this.env.getProperty(SIMULATOR_PUB_SUB_DOMAIN_ENV, String.valueOf(this.pubSubDomain))));
        log.info("Using the simulator configuration: {}", (Object)this.toString());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getInboundDestination() {
        return this.inboundDestination;
    }

    public void setInboundDestination(String inboundDestination) {
        this.inboundDestination = inboundDestination;
    }

    public String getReplyDestination() {
        return this.replyDestination;
    }

    public void setReplyDestination(String replyDestination) {
        this.replyDestination = replyDestination;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public boolean isUseSoap() {
        return this.useSoap;
    }

    public void setUseSoap(boolean useSoap) {
        this.useSoap = useSoap;
    }

    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    public void setPubSubDomain(boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{enabled='" + this.enabled + '\'' + ", inboundDestination='" + this.inboundDestination + '\'' + ", replyDestination='" + this.replyDestination + '\'' + ", synchronous='" + this.synchronous + '\'' + ", useSoap='" + this.useSoap + '\'' + ", pubSubDomain='" + this.pubSubDomain + '\'' + '}';
    }

    public void setEnvironment(Environment environment) {
        this.env = environment;
    }
}

