/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.model;

import com.consol.citrus.simulator.model.MessageHeader;
import com.consol.citrus.simulator.model.ScenarioExecution;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
public class Message
implements Serializable {
    private static final long serialVersionUID = -4858126051234255084L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="MESSAGE_ID")
    private Long messageId;
    @JsonIgnore
    @ManyToOne
    private ScenarioExecution scenarioExecution;
    @Column(nullable=false)
    private Direction direction;
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date date;
    @Column(columnDefinition="CLOB")
    @Lob
    private String payload;
    @Column(unique=true)
    private String citrusMessageId;
    @OneToMany(mappedBy="message", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="name ASC")
    private Collection<MessageHeader> headers = new ArrayList<MessageHeader>();

    public Long getMessageId() {
        return this.messageId;
    }

    public void setMessageId(Long messageId) {
        this.messageId = messageId;
    }

    public ScenarioExecution getScenarioExecution() {
        return this.scenarioExecution;
    }

    public void setScenarioExecution(ScenarioExecution scenarioExecution) {
        this.scenarioExecution = scenarioExecution;
    }

    public Long getScenarioExecutionId() {
        if (this.scenarioExecution != null) {
            return this.scenarioExecution.getExecutionId();
        }
        return null;
    }

    public String getScenarioName() {
        if (this.scenarioExecution != null) {
            return this.scenarioExecution.getScenarioName();
        }
        return null;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public String getCitrusMessageId() {
        return this.citrusMessageId;
    }

    public void setCitrusMessageId(String citrusMessageId) {
        this.citrusMessageId = citrusMessageId;
    }

    public void addHeader(MessageHeader messageHeader) {
        this.headers.add(messageHeader);
        messageHeader.setMessage(this);
    }

    public void removeHeader(MessageHeader messageHeader) {
        this.headers.remove(messageHeader);
        messageHeader.setMessage(null);
    }

    public Collection<MessageHeader> getHeaders() {
        return this.headers;
    }

    public String toString() {
        return "Message{date=" + this.date + ", messageId=" + this.messageId + ", direction=" + (Object)((Object)this.direction) + ", payload='" + this.payload + '\'' + ", citrusMessageId=" + this.citrusMessageId + ", scenarioExecutionId=" + this.getScenarioExecutionId() + ", scenarioName=" + this.getScenarioName() + ", headers=" + this.headers + '}';
    }

    public static enum Direction {
        INBOUND,
        OUTBOUND;

    }
}

