/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.model;

import com.consol.citrus.simulator.model.Message;
import com.consol.citrus.simulator.model.ScenarioAction;
import com.consol.citrus.simulator.model.ScenarioParameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@Entity
public class ScenarioExecution
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ScenarioExecution.class);
    public static final String EXECUTION_ID = "scenarioExecutionId";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="EXECUTION_ID")
    private Long executionId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false)
    private Date startDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date endDate;
    @Column(nullable=false)
    private String scenarioName;
    @Column(nullable=false)
    private Status status;
    @Column(length=1000)
    private String errorMessage;
    @OneToMany(mappedBy="scenarioExecution", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="name ASC")
    private List<ScenarioParameter> scenarioParameters = new ArrayList<ScenarioParameter>();
    @OneToMany(mappedBy="scenarioExecution", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="actionId ASC")
    private List<ScenarioAction> scenarioActions = new ArrayList<ScenarioAction>();
    @OneToMany(mappedBy="scenarioExecution", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="messageId ASC")
    private List<Message> scenarioMessages = new ArrayList<Message>();

    public Long getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(Long executionId) {
        this.executionId = executionId;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public String getScenarioName() {
        return this.scenarioName;
    }

    public void setScenarioName(String scenarioName) {
        this.scenarioName = scenarioName;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (StringUtils.hasLength((String)this.errorMessage)) {
            try {
                int size = this.getClass().getDeclaredField("errorMessage").getAnnotation(Column.class).length();
                int inLength = this.errorMessage.length();
                if (inLength > size) {
                    this.errorMessage = this.errorMessage.substring(0, size);
                }
            }
            catch (NoSuchFieldException | SecurityException ex) {
                LOG.error(String.format("Error truncating error message", errorMessage), (Throwable)ex);
            }
        }
    }

    public Collection<ScenarioParameter> getScenarioParameters() {
        return this.scenarioParameters;
    }

    public void addScenarioParameter(ScenarioParameter scenarioParameter) {
        this.scenarioParameters.add(scenarioParameter);
        scenarioParameter.setScenarioExecution(this);
    }

    public void removeScenarioParameter(ScenarioParameter scenarioParameter) {
        this.scenarioParameters.remove(scenarioParameter);
        scenarioParameter.setScenarioExecution(null);
    }

    public Collection<ScenarioAction> getScenarioActions() {
        return this.scenarioActions;
    }

    public void addScenarioAction(ScenarioAction scenarioAction) {
        this.scenarioActions.add(scenarioAction);
        scenarioAction.setScenarioExecution(this);
    }

    public void removeScenarioAction(ScenarioAction scenarioAction) {
        this.scenarioActions.remove(scenarioAction);
        scenarioAction.setScenarioExecution(null);
    }

    public Collection<Message> getScenarioMessages() {
        return this.scenarioMessages;
    }

    public void addScenarioMessage(Message scenarioMessage) {
        this.scenarioMessages.add(scenarioMessage);
        scenarioMessage.setScenarioExecution(this);
    }

    public void removeScenarioMessage(Message scenarioMessage) {
        this.scenarioMessages.remove(scenarioMessage);
        scenarioMessage.setScenarioExecution(null);
    }

    public String toString() {
        return "ScenarioExecution{endDate=" + this.endDate + ", executionId=" + this.executionId + ", startDate=" + this.startDate + ", scenarioName='" + this.scenarioName + '\'' + ", status=" + (Object)((Object)this.status) + ", errorMessage='" + this.errorMessage + '\'' + ", scenarioParameters=" + this.scenarioParameters + ", scenarioActions=" + this.scenarioActions + ", scenarioMessages=" + this.scenarioMessages + '}';
    }

    public static enum Status {
        ACTIVE,
        SUCCESS,
        FAILED;

    }
}

