/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.model;

import com.consol.citrus.simulator.model.ScenarioParameter;
import com.consol.citrus.simulator.model.ScenarioParameterOption;
import java.util.ArrayList;
import java.util.List;

public class ScenarioParameterBuilder {
    private ScenarioParameter.ControlType controlType = ScenarioParameter.ControlType.TEXTBOX;
    private String label;
    private String name;
    private List<ScenarioParameterOption> options = new ArrayList<ScenarioParameterOption>();
    private boolean required = true;
    private String value = "";

    public ScenarioParameterBuilder textbox() {
        this.controlType = ScenarioParameter.ControlType.TEXTBOX;
        return this;
    }

    public ScenarioParameterBuilder dropdown() {
        this.controlType = ScenarioParameter.ControlType.DROPDOWN;
        return this;
    }

    public ScenarioParameterBuilder textarea() {
        this.controlType = ScenarioParameter.ControlType.TEXTAREA;
        return this;
    }

    public ScenarioParameterBuilder label(String label) {
        this.label = label;
        return this;
    }

    public ScenarioParameterBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ScenarioParameterBuilder addOption(String key, String value) {
        this.options.add(new ScenarioParameterOption(key, value));
        return this;
    }

    public ScenarioParameterBuilder required() {
        this.required = true;
        return this;
    }

    public ScenarioParameterBuilder optional() {
        this.required = false;
        return this;
    }

    public ScenarioParameterBuilder value(String value) {
        this.value = value;
        return this;
    }

    public ScenarioParameter build() {
        ScenarioParameter tp = new ScenarioParameter();
        tp.setControlType(this.controlType);
        tp.setLabel(this.label);
        tp.setName(this.name);
        tp.setOptions(this.options);
        tp.setRequired(this.required);
        tp.setValue(this.value);
        return tp;
    }
}

