/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.scenario;

import com.consol.citrus.TestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.dsl.builder.ReceiveMessageBuilder;
import com.consol.citrus.dsl.builder.SendMessageBuilder;
import com.consol.citrus.dsl.design.DefaultTestDesigner;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.simulator.correlation.CorrelationHandlerBuilder;
import com.consol.citrus.simulator.correlation.CorrelationManager;
import com.consol.citrus.simulator.http.HttpScenarioActionBuilder;
import com.consol.citrus.simulator.scenario.ScenarioEndpoint;
import com.consol.citrus.simulator.ws.SoapScenarioActionBuilder;
import org.springframework.context.ApplicationContext;

public class ScenarioDesigner
extends DefaultTestDesigner {
    private final ScenarioEndpoint scenarioEndpoint;

    public ScenarioDesigner(ScenarioEndpoint scenarioEndpoint, ApplicationContext applicationContext, TestContext context) {
        super(applicationContext, context);
        this.scenarioEndpoint = scenarioEndpoint;
    }

    public CorrelationManager correlation() {
        return () -> {
            CorrelationHandlerBuilder builder = new CorrelationHandlerBuilder(this.scenarioEndpoint, this.getApplicationContext());
            this.action((TestAction)builder);
            this.doFinally().actions(new TestAction[]{builder.stop()});
            return builder;
        };
    }

    public ReceiveMessageBuilder receive() {
        return (ReceiveMessageBuilder)this.receive((Endpoint)this.scenarioEndpoint).description("Receive scenario request");
    }

    public SendMessageBuilder send() {
        return (SendMessageBuilder)this.send((Endpoint)this.scenarioEndpoint).description("Send scenario response");
    }

    public HttpScenarioActionBuilder http() {
        HttpScenarioActionBuilder builder = new HttpScenarioActionBuilder(this.scenarioEndpoint).withApplicationContext(this.getApplicationContext());
        this.action((TestAction)builder);
        return builder;
    }

    public SoapScenarioActionBuilder soap() {
        SoapScenarioActionBuilder builder = new SoapScenarioActionBuilder(this.scenarioEndpoint).withApplicationContext(this.getApplicationContext());
        this.action((TestAction)builder);
        return builder;
    }

    public ScenarioEndpoint scenarioEndpoint() {
        return this.scenarioEndpoint;
    }
}

