/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.scenario.mapper;

import com.consol.citrus.endpoint.adapter.mapping.JsonPayloadMappingKeyExtractor;
import com.consol.citrus.message.Message;
import com.consol.citrus.simulator.scenario.mapper.ScenarioMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ContentBasedJsonPathScenarioMapper
implements ScenarioMapper {
    private static final Logger LOG = LoggerFactory.getLogger(ContentBasedJsonPathScenarioMapper.class);
    private final List<JsonPayloadMappingKeyExtractor> keyExtractors = new ArrayList<JsonPayloadMappingKeyExtractor>();
    private Predicate<String> mappingKeyFilter = StringUtils::hasLength;

    public ContentBasedJsonPathScenarioMapper addJsonPathExpression(String jsonPathExpression) {
        this.keyExtractors.add(this.createFromXPathExpression(jsonPathExpression));
        return this;
    }

    public ContentBasedJsonPathScenarioMapper addMappingKeyFilter(Predicate<String> mappingKeyFilter) {
        this.mappingKeyFilter = mappingKeyFilter;
        return this;
    }

    private JsonPayloadMappingKeyExtractor createFromXPathExpression(String jsonPathExpression) {
        JsonPayloadMappingKeyExtractor mappingKeyExtractor = new JsonPayloadMappingKeyExtractor();
        mappingKeyExtractor.setJsonPathExpression(jsonPathExpression);
        return mappingKeyExtractor;
    }

    public String extractMappingKey(Message request) {
        if (!StringUtils.hasText((String)((String)request.getPayload(String.class)))) {
            return null;
        }
        Optional<String> v = this.keyExtractors.stream().map(keyExtractor -> this.lookupScenarioName(request, (JsonPayloadMappingKeyExtractor)keyExtractor)).filter(Optional::isPresent).map(Optional::get).filter(this.mappingKeyFilter).findFirst();
        return v.orElse(null);
    }

    private Optional<String> lookupScenarioName(Message request, JsonPayloadMappingKeyExtractor keyExtractor) {
        try {
            String mappingKey = keyExtractor.getMappingKey(request);
            LOG.debug("Scenario-name lookup returned: {}", (Object)mappingKey);
            return Optional.of(mappingKey);
        }
        catch (RuntimeException e) {
            LOG.trace("Scenario-name lookup failed", (Throwable)e);
            LOG.debug("Scenario-name lookup returned: <no-match>");
            return Optional.empty();
        }
    }
}

