/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.scenario.mapper;

import com.consol.citrus.message.Message;
import com.consol.citrus.simulator.config.SimulatorConfigurationPropertiesAware;
import com.consol.citrus.simulator.http.HttpOperationScenario;
import com.consol.citrus.simulator.scenario.Scenario;
import com.consol.citrus.simulator.scenario.ScenarioListAware;
import com.consol.citrus.simulator.scenario.SimulatorScenario;
import com.consol.citrus.simulator.scenario.mapper.AbstractScenarioMapper;
import com.consol.citrus.simulator.scenario.mapper.ScenarioMapper;
import io.swagger.models.Operation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public class ScenarioMappers
extends AbstractScenarioMapper
implements ScenarioListAware,
InitializingBean {
    @Autowired(required=false)
    private List<SimulatorScenario> scenarioList = new ArrayList<SimulatorScenario>();
    private final List<ScenarioMapper> scenarioMapperList;

    private ScenarioMappers(ScenarioMapper ... scenarioMapperList) {
        this.scenarioMapperList = Arrays.asList(scenarioMapperList);
    }

    public static ScenarioMappers of(ScenarioMapper ... scenarioMappers) {
        return new ScenarioMappers(scenarioMappers);
    }

    @Override
    public String getMappingKey(Message message) {
        return this.scenarioMapperList.stream().map(mapper -> {
            if (mapper instanceof AbstractScenarioMapper) {
                ((AbstractScenarioMapper)mapper).setUseDefaultMapping(false);
            }
            try {
                return Optional.ofNullable(mapper.extractMappingKey(message));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }).filter(Optional::isPresent).map(Optional::get).filter(StringUtils::hasLength).filter(key -> this.scenarioList.parallelStream().anyMatch(scenario -> {
            if (scenario instanceof HttpOperationScenario) {
                return Optional.ofNullable(((HttpOperationScenario)scenario).getOperation()).map(Operation::getOperationId).orElse("").equals(key);
            }
            return Optional.ofNullable(AnnotationUtils.findAnnotation(scenario.getClass(), Scenario.class)).map(Scenario::value).orElse("").equals(key);
        })).findFirst().orElseGet(() -> super.getMappingKey(message));
    }

    public void afterPropertiesSet() throws Exception {
        this.scenarioMapperList.stream().filter(mapper -> mapper instanceof ScenarioListAware).map(mapper -> (ScenarioListAware)((Object)mapper)).forEach(mapper -> mapper.setScenarioList(this.scenarioList));
        this.scenarioMapperList.stream().filter(mapper -> mapper instanceof SimulatorConfigurationPropertiesAware).map(mapper -> (SimulatorConfigurationPropertiesAware)((Object)mapper)).forEach(mapper -> mapper.setSimulatorConfigurationProperties(this.getSimulatorConfigurationProperties()));
    }

    @Override
    public void setScenarioList(List<SimulatorScenario> scenarioList) {
        this.scenarioList = scenarioList;
    }
}

