/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.service;

import com.consol.citrus.simulator.model.ScenarioParameter;
import com.consol.citrus.simulator.scenario.ScenarioStarter;
import com.consol.citrus.simulator.scenario.SimulatorScenario;
import com.consol.citrus.simulator.scenario.Starter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ScenarioLookupService {
    private static final Logger LOG = LoggerFactory.getLogger(ScenarioLookupService.class);
    private final ApplicationContext applicationContext;
    private Map<String, ScenarioStarter> scenarioStarters;
    private Map<String, SimulatorScenario> scenarios;

    public ScenarioLookupService(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    private void init() {
        this.scenarios = ScenarioLookupService.getSimulatorScenarios(this.applicationContext);
        LOG.info(String.format("Scenarios found: %n%s", Arrays.toString(this.scenarios.keySet().toArray())));
        this.scenarioStarters = ScenarioLookupService.getScenarioStarters(this.applicationContext);
        LOG.info(String.format("Starters found: %n%s", Arrays.toString(this.scenarioStarters.keySet().toArray())));
    }

    public Collection<ScenarioParameter> lookupScenarioParameters(String scenarioName) {
        if (this.scenarioStarters.containsKey(scenarioName)) {
            return this.scenarioStarters.get(scenarioName).getScenarioParameters();
        }
        return Collections.emptyList();
    }

    public Collection<String> getStarterNames() {
        return this.scenarioStarters.keySet().stream().sorted().collect(Collectors.toList());
    }

    public Collection<String> getScenarioNames() {
        return this.scenarios.keySet().stream().sorted().collect(Collectors.toList());
    }

    private static Map<String, SimulatorScenario> getSimulatorScenarios(ApplicationContext context) {
        return context.getBeansOfType(SimulatorScenario.class).entrySet().stream().filter(map -> !((SimulatorScenario)map.getValue()).getClass().isAnnotationPresent(Starter.class)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map<String, ScenarioStarter> getScenarioStarters(ApplicationContext context) {
        return context.getBeansOfType(ScenarioStarter.class).entrySet().stream().filter(map -> ((ScenarioStarter)map.getValue()).getClass().isAnnotationPresent(Starter.class)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

