/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.ws;

import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.endpoint.adapter.EmptyResponseEndpointAdapter;
import com.consol.citrus.simulator.SimulatorAutoConfiguration;
import com.consol.citrus.simulator.endpoint.SimulatorEndpointAdapter;
import com.consol.citrus.simulator.scenario.mapper.ContentBasedXPathScenarioMapper;
import com.consol.citrus.simulator.scenario.mapper.ScenarioMapper;
import com.consol.citrus.simulator.ws.SimulatorWebServiceConfigurationProperties;
import com.consol.citrus.simulator.ws.SimulatorWebServiceConfigurer;
import com.consol.citrus.simulator.ws.SimulatorWebServiceLoggingAutoConfiguration;
import com.consol.citrus.simulator.ws.WsdlScenarioGenerator;
import com.consol.citrus.ws.interceptor.LoggingEndpointInterceptor;
import com.consol.citrus.ws.server.WebServiceEndpoint;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.Servlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.server.EndpointMapping;
import org.springframework.ws.server.endpoint.MessageEndpoint;
import org.springframework.ws.server.endpoint.adapter.MessageEndpointAdapter;
import org.springframework.ws.server.endpoint.mapping.UriEndpointMapping;
import org.springframework.ws.transport.http.MessageDispatcherServlet;

@Configuration
@AutoConfigureAfter(value={SimulatorAutoConfiguration.class})
@Import(value={SimulatorWebServiceLoggingAutoConfiguration.class})
@EnableConfigurationProperties(value={SimulatorWebServiceConfigurationProperties.class})
@ConditionalOnProperty(prefix="citrus.simulator.ws", value={"enabled"}, havingValue="true")
@ConditionalOnWebApplication
public class SimulatorWebServiceAutoConfiguration {
    @Autowired(required=false)
    private SimulatorWebServiceConfigurer configurer;
    @Autowired
    private LoggingEndpointInterceptor loggingEndpointInterceptor;
    @Autowired
    private SimulatorWebServiceConfigurationProperties simulatorWebServiceConfiguration;

    @Bean
    public MessageEndpointAdapter messageEndpointAdapter() {
        return new MessageEndpointAdapter();
    }

    @Bean
    public ServletRegistrationBean<MessageDispatcherServlet> simulatorServletRegistrationBean(ApplicationContext applicationContext) {
        MessageDispatcherServlet servlet = new MessageDispatcherServlet();
        servlet.setApplicationContext(applicationContext);
        servlet.setTransformWsdlLocations(true);
        return new ServletRegistrationBean((Servlet)servlet, new String[]{this.getServletMapping()});
    }

    @Bean
    public EndpointMapping simulatorWsEndpointMapping(ApplicationContext applicationContext) {
        UriEndpointMapping endpointMapping = new UriEndpointMapping();
        endpointMapping.setOrder(Integer.MIN_VALUE);
        endpointMapping.setDefaultEndpoint((Object)this.simulatorWsEndpoint(applicationContext));
        endpointMapping.setInterceptors(this.interceptors());
        return endpointMapping;
    }

    @Bean
    public MessageEndpoint simulatorWsEndpoint(ApplicationContext applicationContext) {
        WebServiceEndpoint webServiceEndpoint = new WebServiceEndpoint();
        SimulatorEndpointAdapter endpointAdapter = this.simulatorWsEndpointAdapter();
        endpointAdapter.setApplicationContext(applicationContext);
        endpointAdapter.setMappingKeyExtractor(this.simulatorWsScenarioMapper());
        endpointAdapter.setFallbackEndpointAdapter(this.simulatorWsFallbackEndpointAdapter());
        webServiceEndpoint.setEndpointAdapter((EndpointAdapter)endpointAdapter);
        return webServiceEndpoint;
    }

    @Bean
    public SimulatorEndpointAdapter simulatorWsEndpointAdapter() {
        return new SimulatorEndpointAdapter();
    }

    @Bean
    public ScenarioMapper simulatorWsScenarioMapper() {
        if (this.configurer != null) {
            return this.configurer.scenarioMapper();
        }
        return new ContentBasedXPathScenarioMapper().addXPathExpression("local-name(/*)");
    }

    @Bean
    public EndpointAdapter simulatorWsFallbackEndpointAdapter() {
        if (this.configurer != null) {
            return this.configurer.fallbackEndpointAdapter();
        }
        return new EmptyResponseEndpointAdapter();
    }

    @Bean
    @ConditionalOnMissingBean(value={WsdlScenarioGenerator.class})
    @ConditionalOnProperty(prefix="citrus.simulator.ws.wsdl", value={"enabled"}, havingValue="true")
    public static WsdlScenarioGenerator simulatorWsdlScenarioGenerator(Environment environment) {
        return new WsdlScenarioGenerator(environment);
    }

    protected String getServletMapping() {
        if (this.configurer != null) {
            return this.configurer.servletMapping(this.simulatorWebServiceConfiguration);
        }
        return this.simulatorWebServiceConfiguration.getServletMapping();
    }

    protected EndpointInterceptor[] interceptors() {
        ArrayList<LoggingEndpointInterceptor> interceptors = new ArrayList<LoggingEndpointInterceptor>();
        if (this.configurer != null) {
            Collections.addAll(interceptors, this.configurer.interceptors());
        }
        interceptors.add(this.loggingEndpointInterceptor);
        return interceptors.toArray(new EndpointInterceptor[interceptors.size()]);
    }
}

