/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.channel;

import com.consol.citrus.channel.ChannelEndpointConfiguration;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.messaging.Producer;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.util.StringUtils;

public class ChannelProducer
implements Producer {
    private static Logger log = LoggerFactory.getLogger(ChannelProducer.class);
    private final String name;
    private ChannelEndpointConfiguration endpointConfiguration;

    public ChannelProducer(String name, ChannelEndpointConfiguration endpointConfiguration) {
        this.name = name;
        this.endpointConfiguration = endpointConfiguration;
    }

    public void send(Message message, TestContext context) {
        String destinationChannelName = this.getDestinationChannelName();
        if (log.isDebugEnabled()) {
            log.debug("Sending message to channel: '" + destinationChannelName + "'");
        }
        if (log.isDebugEnabled()) {
            log.debug("Message to send is:" + System.getProperty("line.separator") + message.toString());
        }
        try {
            this.endpointConfiguration.getMessagingTemplate().send((Object)this.getDestinationChannel(context), this.endpointConfiguration.getMessageConverter().convertOutbound(message, this.endpointConfiguration, context));
        }
        catch (MessageDeliveryException e) {
            throw new CitrusRuntimeException("Failed to send message to channel: '" + destinationChannelName + "'", (Throwable)e);
        }
        log.info("Message was sent to channel: '" + destinationChannelName + "'");
    }

    protected MessageChannel getDestinationChannel(TestContext context) {
        if (this.endpointConfiguration.getChannel() != null) {
            return this.endpointConfiguration.getChannel();
        }
        if (StringUtils.hasText((String)this.endpointConfiguration.getChannelName())) {
            return this.resolveChannelName(this.endpointConfiguration.getChannelName(), context);
        }
        throw new CitrusRuntimeException("Neither channel name nor channel object is set - please specify destination channel");
    }

    protected String getDestinationChannelName() {
        if (this.endpointConfiguration.getChannel() != null) {
            if (this.endpointConfiguration.getChannel() instanceof AbstractMessageChannel) {
                return ((AbstractMessageChannel)this.endpointConfiguration.getChannel()).getBeanName();
            }
            return this.endpointConfiguration.getChannel().toString();
        }
        if (StringUtils.hasText((String)this.endpointConfiguration.getChannelName())) {
            return this.endpointConfiguration.getChannelName();
        }
        throw new CitrusRuntimeException("Neither channel name nor channel object is set - please specify destination channel");
    }

    protected MessageChannel resolveChannelName(String channelName, TestContext context) {
        return Optional.ofNullable(this.endpointConfiguration.getChannelResolver()).map(resolver -> (MessageChannel)resolver.resolveDestination(channelName)).orElseGet(() -> {
            if (this.endpointConfiguration.getBeanFactory() != null) {
                return new BeanFactoryChannelResolver(this.endpointConfiguration.getBeanFactory()).resolveDestination(channelName);
            }
            return (MessageChannel)context.getReferenceResolver().resolve(channelName, MessageChannel.class);
        });
    }

    public String getName() {
        return this.name;
    }
}

