/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.channel.selector;

import com.consol.citrus.channel.selector.AbstractMessageSelector;
import com.consol.citrus.channel.selector.MessageSelectorFactory;
import com.consol.citrus.context.TestContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

public class HeaderMatchingMessageSelector
extends AbstractMessageSelector {
    public static final String SELECTOR_PREFIX = "header:";

    public HeaderMatchingMessageSelector(String selectKey, String matchingValue, TestContext context) {
        super(selectKey, matchingValue, context);
    }

    public boolean accept(Message<?> message) {
        MessageHeaders messageHeaders = message.getHeaders();
        HashMap<String, Object> nestedMessageHeaders = new HashMap();
        if (message.getPayload() instanceof com.consol.citrus.message.Message) {
            nestedMessageHeaders = ((com.consol.citrus.message.Message)message.getPayload()).getHeaders();
        }
        if (nestedMessageHeaders.containsKey(this.selectKey)) {
            return this.matchHeader(nestedMessageHeaders);
        }
        if (messageHeaders.containsKey((Object)this.selectKey)) {
            return this.matchHeader((Map<String, Object>)messageHeaders);
        }
        return false;
    }

    private boolean matchHeader(Map<String, Object> messageHeaders) {
        return Optional.ofNullable(messageHeaders.get(this.selectKey)).map(Object::toString).map(this::evaluate).orElse(false);
    }

    public static class Factory
    implements MessageSelectorFactory<HeaderMatchingMessageSelector> {
        @Override
        public boolean supports(String key) {
            return key.startsWith(HeaderMatchingMessageSelector.SELECTOR_PREFIX);
        }

        @Override
        public HeaderMatchingMessageSelector create(String key, String value, TestContext context) {
            if (key.startsWith(HeaderMatchingMessageSelector.SELECTOR_PREFIX)) {
                return new HeaderMatchingMessageSelector(key.substring(HeaderMatchingMessageSelector.SELECTOR_PREFIX.length()), value, context);
            }
            return new HeaderMatchingMessageSelector(key, value, context);
        }
    }
}

