/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.channel.ChannelEndpoint;
import com.consol.citrus.channel.ChannelEndpointBuilder;
import com.consol.citrus.channel.ChannelMessageConverter;
import com.consol.citrus.config.annotation.AnnotationConfigParser;
import com.consol.citrus.config.annotation.ChannelEndpointConfig;
import com.consol.citrus.spi.ReferenceResolver;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.util.StringUtils;

public class ChannelEndpointConfigParser
implements AnnotationConfigParser<ChannelEndpointConfig, ChannelEndpoint> {
    public ChannelEndpoint parse(ChannelEndpointConfig annotation, ReferenceResolver referenceResolver) {
        ChannelEndpointBuilder builder = new ChannelEndpointBuilder();
        String channel = annotation.channel();
        String channelName = annotation.channelName();
        if (StringUtils.hasText((String)channel)) {
            builder.channel((MessageChannel)referenceResolver.resolve(annotation.channel(), MessageChannel.class));
        }
        if (StringUtils.hasText((String)channelName)) {
            builder.channel(annotation.channelName());
        }
        if (StringUtils.hasText((String)annotation.messagingTemplate())) {
            String messagingTemplate = "messagingTemplate";
            if (StringUtils.hasText((String)annotation.messagingTemplate())) {
                messagingTemplate = annotation.messagingTemplate();
            }
            builder.messagingTemplate((MessagingTemplate)referenceResolver.resolve(messagingTemplate, MessagingTemplate.class));
        }
        builder.useObjectMessages(annotation.useObjectMessages());
        builder.filterInternalHeaders(annotation.filterInternalHeaders());
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((ChannelMessageConverter)referenceResolver.resolve(annotation.messageConverter(), ChannelMessageConverter.class));
        }
        if (StringUtils.hasText((String)annotation.channelResolver())) {
            builder.channelResolver((DestinationResolver)referenceResolver.resolve(annotation.channelResolver(), DestinationResolver.class));
        }
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        return (ChannelEndpoint)builder.initialize().build();
    }
}

