/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.channel;

import com.consol.citrus.channel.ChannelEndpointConfiguration;
import com.consol.citrus.channel.MessageSelectingQueueChannel;
import com.consol.citrus.channel.selector.DispatchingMessageSelector;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.MessageTimeoutException;
import com.consol.citrus.message.Message;
import com.consol.citrus.messaging.AbstractSelectiveMessageConsumer;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.PollableChannel;
import org.springframework.util.StringUtils;

public class ChannelConsumer
extends AbstractSelectiveMessageConsumer {
    private static Logger log = LoggerFactory.getLogger(ChannelConsumer.class);
    private ChannelEndpointConfiguration endpointConfiguration;

    public ChannelConsumer(String name, ChannelEndpointConfiguration endpointConfiguration) {
        super(name, (EndpointConfiguration)endpointConfiguration);
        this.endpointConfiguration = endpointConfiguration;
    }

    public Message receive(String selector, TestContext context, long timeout) {
        Message message;
        MessageChannel destinationChannel = this.getDestinationChannel(context);
        Object destinationChannelName = StringUtils.hasText((String)selector) ? this.getDestinationChannelName() + "(" + selector + ")" : this.getDestinationChannelName();
        if (log.isDebugEnabled()) {
            log.debug("Receiving message from: " + (String)destinationChannelName);
        }
        if (StringUtils.hasText((String)selector)) {
            if (!(destinationChannel instanceof MessageSelectingQueueChannel)) {
                throw new CitrusRuntimeException("Message channel type '" + this.endpointConfiguration.getChannel().getClass() + "' does not support selective receive operations.");
            }
            DispatchingMessageSelector messageSelector = new DispatchingMessageSelector(selector, this.endpointConfiguration.getBeanFactory(), context);
            MessageSelectingQueueChannel queueChannel = (MessageSelectingQueueChannel)destinationChannel;
            message = timeout <= 0L ? this.endpointConfiguration.getMessageConverter().convertInbound(queueChannel.receive(messageSelector), this.endpointConfiguration, context) : this.endpointConfiguration.getMessageConverter().convertInbound(queueChannel.receive(messageSelector, timeout), this.endpointConfiguration, context);
        } else {
            if (!(destinationChannel instanceof PollableChannel)) {
                throw new CitrusRuntimeException("Invalid destination channel type " + destinationChannel.getClass().getName() + " - must be of type PollableChannel");
            }
            this.endpointConfiguration.getMessagingTemplate().setReceiveTimeout(timeout);
            message = this.endpointConfiguration.getMessageConverter().convertInbound(this.endpointConfiguration.getMessagingTemplate().receive((Object)((PollableChannel)destinationChannel)), this.endpointConfiguration, context);
        }
        if (message == null) {
            throw new MessageTimeoutException(timeout, (String)destinationChannelName);
        }
        log.debug("Received message from: " + (String)destinationChannelName);
        return message;
    }

    protected MessageChannel getDestinationChannel(TestContext context) {
        if (this.endpointConfiguration.getChannel() != null) {
            return this.endpointConfiguration.getChannel();
        }
        if (StringUtils.hasText((String)this.endpointConfiguration.getChannelName())) {
            return this.resolveChannelName(this.endpointConfiguration.getChannelName(), context);
        }
        throw new CitrusRuntimeException("Neither channel name nor channel object is set - please specify destination channel");
    }

    protected String getDestinationChannelName() {
        if (this.endpointConfiguration.getChannel() != null) {
            return this.endpointConfiguration.getChannel().toString();
        }
        if (StringUtils.hasText((String)this.endpointConfiguration.getChannelName())) {
            return this.endpointConfiguration.getChannelName();
        }
        throw new CitrusRuntimeException("Neither channel name nor channel object is set - please specify destination channel");
    }

    protected MessageChannel resolveChannelName(String channelName, TestContext context) {
        return Optional.ofNullable(this.endpointConfiguration.getChannelResolver()).map(resolver -> (MessageChannel)resolver.resolveDestination(channelName)).orElseGet(() -> {
            if (this.endpointConfiguration.getBeanFactory() != null) {
                return new BeanFactoryChannelResolver(this.endpointConfiguration.getBeanFactory()).resolveDestination(channelName);
            }
            return (MessageChannel)context.getReferenceResolver().resolve(channelName, MessageChannel.class);
        });
    }
}

