/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.config.xml.PayloadElementParser;
import com.consol.citrus.message.DelegatingPathExpressionProcessor;
import com.consol.citrus.message.MessageHeaderBuilder;
import com.consol.citrus.message.MessageHeaderType;
import com.consol.citrus.message.MessagePayloadBuilder;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.message.builder.DefaultHeaderBuilder;
import com.consol.citrus.message.builder.DefaultHeaderDataBuilder;
import com.consol.citrus.message.builder.DefaultPayloadBuilder;
import com.consol.citrus.message.builder.FileResourceHeaderDataBuilder;
import com.consol.citrus.message.builder.FileResourcePayloadBuilder;
import com.consol.citrus.message.builder.script.GroovyFileResourcePayloadBuilder;
import com.consol.citrus.message.builder.script.GroovyScriptPayloadBuilder;
import com.consol.citrus.validation.builder.DefaultMessageContentBuilder;
import com.consol.citrus.validation.context.HeaderValidationContext;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.validation.interceptor.BinaryMessageProcessor;
import com.consol.citrus.validation.interceptor.GzipMessageProcessor;
import com.consol.citrus.variable.MessageHeaderVariableExtractor;
import com.consol.citrus.variable.VariableExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractMessageActionParser
implements BeanDefinitionParser {
    public DefaultMessageContentBuilder constructMessageBuilder(Element messageElement, BeanDefinitionBuilder actionBuilder) {
        DefaultMessageContentBuilder messageBuilder = null;
        if (messageElement != null && (messageBuilder = this.parsePayloadTemplateBuilder(messageElement, actionBuilder)) == null) {
            messageBuilder = this.parseScriptBuilder(messageElement);
        }
        if (messageBuilder == null) {
            messageBuilder = new DefaultMessageContentBuilder();
        }
        if (messageElement != null && messageElement.hasAttribute("name")) {
            messageBuilder.setName(messageElement.getAttribute("name"));
        }
        return messageBuilder;
    }

    private DefaultMessageContentBuilder parseScriptBuilder(Element messageElement) {
        DefaultMessageContentBuilder scriptMessageBuilder = null;
        Element builderElement = DomUtils.getChildElementByTagName((Element)messageElement, (String)"builder");
        if (builderElement != null) {
            String builderType = builderElement.getAttribute("type");
            if (!StringUtils.hasText((String)builderType)) {
                throw new BeanCreationException("Missing message builder type - please define valid type attribute for message builder");
            }
            if (!builderType.equals("groovy")) {
                throw new BeanCreationException("Unsupported message builder type: '" + builderType + "'");
            }
            scriptMessageBuilder = new DefaultMessageContentBuilder();
            String scriptResourcePath = builderElement.getAttribute("file");
            if (StringUtils.hasText((String)scriptResourcePath)) {
                if (builderElement.hasAttribute("charset")) {
                    scriptMessageBuilder.setPayloadBuilder((MessagePayloadBuilder)new GroovyFileResourcePayloadBuilder(scriptResourcePath, builderElement.getAttribute("charset")));
                } else {
                    scriptMessageBuilder.setPayloadBuilder((MessagePayloadBuilder)new GroovyFileResourcePayloadBuilder(scriptResourcePath));
                }
            } else {
                scriptMessageBuilder.setPayloadBuilder((MessagePayloadBuilder)new GroovyScriptPayloadBuilder(DomUtils.getTextValue((Element)builderElement).trim()));
            }
        }
        if (scriptMessageBuilder != null && messageElement.hasAttribute("name")) {
            scriptMessageBuilder.setName(messageElement.getAttribute("name"));
        }
        return scriptMessageBuilder;
    }

    private DefaultMessageContentBuilder parsePayloadTemplateBuilder(Element messageElement, BeanDefinitionBuilder actionBuilder) {
        Element xmlResourceElement;
        DefaultMessageContentBuilder messageBuilder = this.parsePayloadElement(messageElement);
        Element xmlDataElement = DomUtils.getChildElementByTagName((Element)messageElement, (String)"data");
        if (xmlDataElement != null) {
            messageBuilder = new DefaultMessageContentBuilder();
            messageBuilder.setPayloadBuilder((MessagePayloadBuilder)new DefaultPayloadBuilder((Object)DomUtils.getTextValue((Element)xmlDataElement).trim()));
        }
        if ((xmlResourceElement = DomUtils.getChildElementByTagName((Element)messageElement, (String)"resource")) != null) {
            messageBuilder = new DefaultMessageContentBuilder();
            if (xmlResourceElement.hasAttribute("charset")) {
                messageBuilder.setPayloadBuilder((MessagePayloadBuilder)new FileResourcePayloadBuilder(xmlResourceElement.getAttribute("file"), xmlResourceElement.getAttribute("charset")));
            } else {
                messageBuilder.setPayloadBuilder((MessagePayloadBuilder)new FileResourcePayloadBuilder(xmlResourceElement.getAttribute("file")));
            }
        }
        if (messageBuilder != null) {
            String messageType;
            HashMap<String, Object> pathExpressions = new HashMap<String, Object>();
            List messageValueElements = DomUtils.getChildElementsByTagName((Element)messageElement, (String)"element");
            for (Element messageValue : messageValueElements) {
                String pathExpression = messageValue.getAttribute("path");
                pathExpressions.put(pathExpression, messageValue.getAttribute("value"));
            }
            ArrayList<DelegatingPathExpressionProcessor> messageProcessors = new ArrayList<DelegatingPathExpressionProcessor>();
            if (!pathExpressions.isEmpty()) {
                messageProcessors.add(new DelegatingPathExpressionProcessor(pathExpressions));
            }
            if (StringUtils.hasText((String)(messageType = messageElement.getAttribute("type")))) {
                if (messageType.equalsIgnoreCase(MessageType.GZIP.name())) {
                    messageProcessors.add((DelegatingPathExpressionProcessor)new GzipMessageProcessor());
                }
                if (messageType.equalsIgnoreCase(MessageType.BINARY.name())) {
                    messageProcessors.add((DelegatingPathExpressionProcessor)new BinaryMessageProcessor());
                }
            }
            actionBuilder.addPropertyValue("messageProcessors", messageProcessors);
        }
        return messageBuilder;
    }

    private DefaultMessageContentBuilder parsePayloadElement(Element messageElement) {
        DefaultMessageContentBuilder messageBuilder = null;
        Element payloadElement = DomUtils.getChildElementByTagName((Element)messageElement, (String)"payload");
        if (payloadElement != null) {
            List payload;
            messageBuilder = new DefaultMessageContentBuilder();
            if (messageElement.hasAttribute("name")) {
                messageBuilder.setName(messageElement.getAttribute("name"));
            }
            if (!CollectionUtils.isEmpty((Collection)(payload = DomUtils.getChildElements((Element)payloadElement)))) {
                messageBuilder.setPayloadBuilder((MessagePayloadBuilder)new DefaultPayloadBuilder((Object)PayloadElementParser.parseMessagePayload((Element)payload.get(0))));
            }
        }
        return messageBuilder;
    }

    protected void parseHeaderElements(Element actionElement, DefaultMessageContentBuilder messageBuilder, List<ValidationContext> validationContexts) {
        Element headerElement = DomUtils.getChildElementByTagName((Element)actionElement, (String)"header");
        LinkedHashMap<String, String> messageHeaders = new LinkedHashMap<String, String>();
        if (headerElement != null) {
            List elements = DomUtils.getChildElementsByTagName((Element)headerElement, (String)"element");
            for (Object headerValue : elements) {
                String name = headerValue.getAttribute("name");
                String value = headerValue.getAttribute("value");
                String type = headerValue.getAttribute("type");
                if (StringUtils.hasText((String)type)) {
                    value = MessageHeaderType.createTypedValue((String)type, (String)value);
                }
                messageHeaders.put(name, value);
            }
            List headerDataElements = DomUtils.getChildElementsByTagName((Element)headerElement, (String)"data");
            for (Object headerDataElement : headerDataElements) {
                messageBuilder.addHeaderBuilder((MessageHeaderBuilder)new DefaultHeaderDataBuilder((Object)DomUtils.getTextValue((Element)headerDataElement).trim()));
            }
            List headerResourceElements = DomUtils.getChildElementsByTagName((Element)headerElement, (String)"resource");
            for (Object headerResourceElement : headerResourceElements) {
                String charset = headerResourceElement.getAttribute("charset");
                messageBuilder.addHeaderBuilder((MessageHeaderBuilder)new FileResourceHeaderDataBuilder(headerResourceElement.getAttribute("file") + (StringUtils.hasText((String)charset) ? ";charset=" + charset : "")));
            }
            List headerFragmentElements = DomUtils.getChildElementsByTagName((Element)headerElement, (String)"fragment");
            for (Element headerFragmentElement : headerFragmentElements) {
                List fragment = DomUtils.getChildElements((Element)headerFragmentElement);
                if (CollectionUtils.isEmpty((Collection)fragment)) continue;
                messageBuilder.addHeaderBuilder((MessageHeaderBuilder)new DefaultHeaderDataBuilder((Object)PayloadElementParser.parseMessagePayload((Element)fragment.get(0))));
            }
            messageBuilder.addHeaderBuilder((MessageHeaderBuilder)new DefaultHeaderBuilder(messageHeaders));
            if (headerElement.hasAttribute("ignore-case")) {
                boolean ignoreCase = Boolean.parseBoolean(headerElement.getAttribute("ignore-case"));
                validationContexts.stream().filter(context -> context instanceof HeaderValidationContext).map(context -> (HeaderValidationContext)context).forEach(context -> context.setHeaderNameIgnoreCase(ignoreCase));
            }
        }
    }

    protected void parseExtractHeaderElements(Element element, List<VariableExtractor> variableExtractors) {
        Element extractElement = DomUtils.getChildElementByTagName((Element)element, (String)"extract");
        HashMap<String, String> extractHeaderValues = new HashMap<String, String>();
        if (extractElement != null) {
            List headerValueElements = DomUtils.getChildElementsByTagName((Element)extractElement, (String)"header");
            for (Element headerValue : headerValueElements) {
                extractHeaderValues.put(headerValue.getAttribute("name"), headerValue.getAttribute("variable"));
            }
            MessageHeaderVariableExtractor headerVariableExtractor = new MessageHeaderVariableExtractor.Builder().headers(extractHeaderValues).build();
            if (!CollectionUtils.isEmpty(extractHeaderValues)) {
                variableExtractors.add((VariableExtractor)headerVariableExtractor);
            }
        }
    }
}

