/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.actions.SendMessageAction;
import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.config.xml.AbstractMessageActionParser;
import com.consol.citrus.config.xml.AbstractSendMessageActionFactoryBean;
import com.consol.citrus.config.xml.DescriptionElementParser;
import com.consol.citrus.validation.builder.DefaultMessageContentBuilder;
import com.consol.citrus.variable.VariableExtractor;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SendMessageActionParser
extends AbstractMessageActionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String endpointUri = element.getAttribute("endpoint");
        if (!StringUtils.hasText((String)endpointUri)) {
            throw new BeanCreationException("Endpoint reference must not be empty");
        }
        BeanDefinitionBuilder builder = this.parseComponent(element, parserContext);
        builder.addPropertyValue("name", (Object)element.getLocalName());
        if (endpointUri.contains(":") || endpointUri.contains("${") && endpointUri.contains("}")) {
            builder.addPropertyValue("endpointUri", (Object)endpointUri);
        } else {
            builder.addPropertyReference("endpoint", endpointUri);
        }
        DescriptionElementParser.doParse(element, builder);
        BeanDefinitionParserUtils.setPropertyReference(builder, element.getAttribute("actor"), "actor");
        BeanDefinitionParserUtils.setPropertyValue(builder, element.getAttribute("fork"), "forkMode");
        Element messageElement = DomUtils.getChildElementByTagName((Element)element, (String)"message");
        if (messageElement != null) {
            String dataDictionary;
            String messageType = messageElement.getAttribute("type");
            if (StringUtils.hasText((String)messageType)) {
                builder.addPropertyValue("messageType", (Object)messageType);
            }
            if (StringUtils.hasText((String)(dataDictionary = messageElement.getAttribute("data-dictionary")))) {
                builder.addPropertyReference("dataDictionary", dataDictionary);
            }
        }
        DefaultMessageContentBuilder messageBuilder = this.constructMessageBuilder(messageElement, builder);
        this.parseHeaderElements(element, messageBuilder, Collections.emptyList());
        if (messageBuilder != null) {
            builder.addPropertyValue("messageBuilder", (Object)messageBuilder);
        }
        ArrayList<VariableExtractor> variableExtractors = new ArrayList<VariableExtractor>();
        this.parseExtractHeaderElements(element, variableExtractors);
        if (!variableExtractors.isEmpty()) {
            builder.addPropertyValue("variableExtractors", variableExtractors);
        }
        return builder.getBeanDefinition();
    }

    protected BeanDefinitionBuilder parseComponent(Element element, ParserContext parserContext) {
        return BeanDefinitionBuilder.genericBeanDefinition(this.getBeanDefinitionClass());
    }

    protected Class<? extends AbstractSendMessageActionFactoryBean<?, ?>> getBeanDefinitionClass() {
        return SendMessageActionFactoryBean.class;
    }

    public static class SendMessageActionFactoryBean
    extends AbstractSendMessageActionFactoryBean<SendMessageAction, SendMessageAction.Builder> {
        private final SendMessageAction.Builder builder = new SendMessageAction.Builder();

        public SendMessageAction getObject() throws Exception {
            return this.builder.build();
        }

        public Class<?> getObjectType() {
            return SendMessageAction.class;
        }

        @Override
        public SendMessageAction.Builder getBuilder() {
            return this.builder;
        }
    }
}

