/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.DefaultTestCase;
import com.consol.citrus.TestCaseMetaInfo;
import com.consol.citrus.config.TestActionRegistry;
import com.consol.citrus.config.TestCaseFactory;
import com.consol.citrus.config.xml.DescriptionElementParser;
import com.consol.citrus.variable.VariableUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class TestCaseParser
implements BeanDefinitionParser {
    public final BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder testCaseFactory = BeanDefinitionBuilder.rootBeanDefinition(TestCaseFactory.class);
        BeanDefinitionBuilder testCase = BeanDefinitionBuilder.rootBeanDefinition(DefaultTestCase.class);
        String testName = element.getAttribute("name");
        if (!StringUtils.hasText((String)testName)) {
            throw new BeanCreationException("Please provide proper test case name");
        }
        testCase.addPropertyValue("name", (Object)testName);
        this.parseMetaInfo(testCase, element);
        this.parseVariableDefinitions(testCase, element);
        DescriptionElementParser.doParse(element, testCase);
        Element actionsElement = DomUtils.getChildElementByTagName((Element)element, (String)"actions");
        Element finallyBlockElement = DomUtils.getChildElementByTagName((Element)element, (String)"finally");
        testCaseFactory.addPropertyValue("testCase", (Object)testCase.getBeanDefinition());
        testCaseFactory.addPropertyValue("testActions", this.parseActions(actionsElement, parserContext));
        testCaseFactory.addPropertyValue("finalActions", this.parseActions(finallyBlockElement, parserContext));
        parserContext.getRegistry().registerBeanDefinition(testName, (BeanDefinition)testCaseFactory.getBeanDefinition());
        return parserContext.getRegistry().getBeanDefinition(testName);
    }

    private ManagedList<BeanDefinition> parseActions(Element actionsContainerElement, ParserContext parserContext) {
        ManagedList actions = new ManagedList();
        if (actionsContainerElement != null) {
            List actionList = DomUtils.getChildElements((Element)actionsContainerElement);
            for (Element action : actionList) {
                BeanDefinitionParser parser = null;
                if (action.getNamespaceURI().equals(actionsContainerElement.getNamespaceURI())) {
                    parser = TestActionRegistry.getActionParser(action.getLocalName());
                }
                if (parser == null) {
                    actions.add((Object)parserContext.getReaderContext().getNamespaceHandlerResolver().resolve(action.getNamespaceURI()).parse(action, parserContext));
                    continue;
                }
                actions.add((Object)parser.parse(action, parserContext));
            }
        }
        return actions;
    }

    private void parseVariableDefinitions(BeanDefinitionBuilder testCase, Element element) {
        Element variablesElement = DomUtils.getChildElementByTagName((Element)element, (String)"variables");
        if (variablesElement != null) {
            LinkedHashMap<String, String> testVariables = new LinkedHashMap<String, String>();
            List variableElements = DomUtils.getChildElementsByTagName((Element)variablesElement, (String)"variable");
            for (Element variableDefinition : variableElements) {
                Element variableData;
                Element variableValueElement = DomUtils.getChildElementByTagName((Element)variableDefinition, (String)"value");
                if (variableValueElement == null) {
                    testVariables.put(variableDefinition.getAttribute("name"), variableDefinition.getAttribute("value"));
                    continue;
                }
                Element variableScript = DomUtils.getChildElementByTagName((Element)variableValueElement, (String)"script");
                if (variableScript != null) {
                    String scriptEngine = variableScript.getAttribute("type");
                    testVariables.put(variableDefinition.getAttribute("name"), VariableUtils.getValueFromScript((String)scriptEngine, (String)variableScript.getTextContent()));
                }
                if ((variableData = DomUtils.getChildElementByTagName((Element)variableValueElement, (String)"data")) == null) continue;
                testVariables.put(variableDefinition.getAttribute("name"), DomUtils.getTextValue((Element)variableData).trim());
            }
            testCase.addPropertyValue("variableDefinitions", testVariables);
        }
    }

    private void parseMetaInfo(BeanDefinitionBuilder testCase, Element element) {
        Element metaInfoElement = DomUtils.getChildElementByTagName((Element)element, (String)"meta-info");
        if (metaInfoElement != null) {
            TestCaseMetaInfo metaInfo = new TestCaseMetaInfo();
            Element authorElement = DomUtils.getChildElementByTagName((Element)metaInfoElement, (String)"author");
            Element creationDateElement = DomUtils.getChildElementByTagName((Element)metaInfoElement, (String)"creationdate");
            Element statusElement = DomUtils.getChildElementByTagName((Element)metaInfoElement, (String)"status");
            Element lastUpdatedByElement = DomUtils.getChildElementByTagName((Element)metaInfoElement, (String)"last-updated-by");
            Element lastUpdatedOnElement = DomUtils.getChildElementByTagName((Element)metaInfoElement, (String)"last-updated-on");
            metaInfo.setAuthor(DomUtils.getTextValue((Element)authorElement));
            try {
                metaInfo.setCreationDate(new SimpleDateFormat("yyyy-MM-dd").parse(DomUtils.getTextValue((Element)creationDateElement)));
            }
            catch (ParseException e) {
                throw new BeanCreationException("Unable to parse creation date", (Throwable)e);
            }
            String status = DomUtils.getTextValue((Element)statusElement);
            if (status.equals("DRAFT")) {
                metaInfo.setStatus(TestCaseMetaInfo.Status.DRAFT);
            } else if (status.equals("READY_FOR_REVIEW")) {
                metaInfo.setStatus(TestCaseMetaInfo.Status.READY_FOR_REVIEW);
            } else if (status.equals("FINAL")) {
                metaInfo.setStatus(TestCaseMetaInfo.Status.FINAL);
            } else if (status.equals("DISABLED")) {
                metaInfo.setStatus(TestCaseMetaInfo.Status.DISABLED);
            }
            if (lastUpdatedByElement != null) {
                metaInfo.setLastUpdatedBy(DomUtils.getTextValue((Element)lastUpdatedByElement));
            }
            if (lastUpdatedOnElement != null) {
                try {
                    metaInfo.setLastUpdatedOn(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(DomUtils.getTextValue((Element)lastUpdatedOnElement)));
                }
                catch (ParseException e) {
                    throw new BeanCreationException("Unable to parse lastupdate date", (Throwable)e);
                }
            }
            testCase.addPropertyValue("metaInfo", (Object)metaInfo);
        }
    }
}

