/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.context;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.SimpleReferenceResolver;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringBeanReferenceResolver
implements ReferenceResolver,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private ReferenceResolver fallback = new SimpleReferenceResolver();

    public SpringBeanReferenceResolver() {
    }

    public SpringBeanReferenceResolver(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public <T> T resolve(Class<T> requiredType) {
        try {
            return (T)this.applicationContext.getBean(requiredType);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new CitrusRuntimeException(String.format("Unable to find bean reference for type '%s'", requiredType), (Throwable)e);
        }
    }

    public <T> T resolve(String name, Class<T> type) {
        try {
            return (T)this.applicationContext.getBean(name, type);
        }
        catch (NoSuchBeanDefinitionException e) {
            if (this.fallback.isResolvable(name)) {
                return (T)this.fallback.resolve(name, type);
            }
            throw new CitrusRuntimeException(String.format("Unable to find bean reference for name '%s'", name), (Throwable)e);
        }
    }

    public Object resolve(String name) {
        try {
            return this.applicationContext.getBean(name);
        }
        catch (NoSuchBeanDefinitionException e) {
            if (this.fallback.isResolvable(name)) {
                return this.fallback.resolve(name);
            }
            throw new CitrusRuntimeException(String.format("Unable to find bean reference for name '%s'", name), (Throwable)e);
        }
    }

    public <T> Map<String, T> resolveAll(Class<T> requiredType) {
        try {
            return this.applicationContext.getBeansOfType(requiredType);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new CitrusRuntimeException(String.format("Unable to find bean references for type '%s'", requiredType), (Throwable)e);
        }
    }

    public boolean isResolvable(String name) {
        return this.applicationContext.containsBean(name) || this.fallback.isResolvable(name);
    }

    public SpringBeanReferenceResolver withFallback(ReferenceResolver fallback) {
        this.fallback = fallback;
        return this;
    }

    public void bind(String name, Object value) {
        this.fallback.bind(name, value);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setFallback(ReferenceResolver fallback) {
        this.fallback = fallback;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

