/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.handler;

import com.consol.citrus.config.xml.DefaultMessageQueueParser;
import com.consol.citrus.config.xml.DirectEndpointAdapterParser;
import com.consol.citrus.config.xml.DirectEndpointParser;
import com.consol.citrus.config.xml.DirectSyncEndpointParser;
import com.consol.citrus.config.xml.EmptyResponseEndpointAdapterParser;
import com.consol.citrus.config.xml.FunctionLibraryParser;
import com.consol.citrus.config.xml.GlobalVariablesParser;
import com.consol.citrus.config.xml.MessageValidatorRegistryParser;
import com.consol.citrus.config.xml.NamespaceContextParser;
import com.consol.citrus.config.xml.RequestDispatchingEndpointAdapterParser;
import com.consol.citrus.config.xml.SchemaParser;
import com.consol.citrus.config.xml.SchemaRepositoryParser;
import com.consol.citrus.config.xml.SequenceAfterSuiteParser;
import com.consol.citrus.config.xml.SequenceAfterTestParser;
import com.consol.citrus.config.xml.SequenceBeforeSuiteParser;
import com.consol.citrus.config.xml.SequenceBeforeTestParser;
import com.consol.citrus.config.xml.StaticResponseEndpointAdapterParser;
import com.consol.citrus.config.xml.TestActorParser;
import com.consol.citrus.config.xml.TimeoutProducingEndpointAdapterParser;
import com.consol.citrus.config.xml.ValidationMatcherLibraryParser;
import com.consol.citrus.spi.ResourcePathTypeResolver;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class CitrusConfigNamespaceHandler
extends NamespaceHandlerSupport {
    private static Logger log = LoggerFactory.getLogger(CitrusConfigNamespaceHandler.class);
    private static final String RESOURCE_PATH = "META-INF/citrus/config/parser/core";

    public void init() {
        this.registerBeanDefinitionParser("schema-repository", new SchemaRepositoryParser());
        this.registerBeanDefinitionParser("schema", new SchemaParser());
        this.registerBeanDefinitionParser("actor", new TestActorParser());
        this.registerBeanDefinitionParser("global-variables", new GlobalVariablesParser());
        this.registerBeanDefinitionParser("message-validators", new MessageValidatorRegistryParser());
        this.registerBeanDefinitionParser("namespace-context", new NamespaceContextParser());
        this.registerBeanDefinitionParser("function-library", new FunctionLibraryParser());
        this.registerBeanDefinitionParser("validation-matcher-library", new ValidationMatcherLibraryParser());
        this.registerBeanDefinitionParser("before-suite", new SequenceBeforeSuiteParser());
        this.registerBeanDefinitionParser("before-test", new SequenceBeforeTestParser());
        this.registerBeanDefinitionParser("after-suite", new SequenceAfterSuiteParser());
        this.registerBeanDefinitionParser("after-test", new SequenceAfterTestParser());
        this.registerBeanDefinitionParser("direct-endpoint", (BeanDefinitionParser)new DirectEndpointParser());
        this.registerBeanDefinitionParser("direct-sync-endpoint", (BeanDefinitionParser)new DirectSyncEndpointParser());
        this.registerBeanDefinitionParser("queue", new DefaultMessageQueueParser());
        this.registerBeanDefinitionParser("message-queue", new DefaultMessageQueueParser());
        this.registerBeanDefinitionParser("direct-endpoint-adapter", (BeanDefinitionParser)new DirectEndpointAdapterParser());
        this.registerBeanDefinitionParser("dispatching-endpoint-adapter", (BeanDefinitionParser)new RequestDispatchingEndpointAdapterParser());
        this.registerBeanDefinitionParser("static-response-adapter", (BeanDefinitionParser)new StaticResponseEndpointAdapterParser());
        this.registerBeanDefinitionParser("empty-response-adapter", (BeanDefinitionParser)new EmptyResponseEndpointAdapterParser());
        this.registerBeanDefinitionParser("timeout-producing-adapter", (BeanDefinitionParser)new TimeoutProducingEndpointAdapterParser());
        this.lookupBeanDefinitionParser();
    }

    private void lookupBeanDefinitionParser() {
        Map actionParserMap = new ResourcePathTypeResolver().resolveAll(RESOURCE_PATH);
        actionParserMap.forEach((k, p) -> {
            this.registerBeanDefinitionParser((String)k, (BeanDefinitionParser)p);
            log.info(String.format("Register bean definition parser %s from resource %s", p.getClass(), k));
        });
    }
}

