/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.variable.dictionary.DataDictionary;
import java.util.HashMap;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractDataDictionaryParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Element mappingFile;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(this.getDictionaryClass());
        builder.addPropertyValue("name", (Object)element.getAttribute("id"));
        BeanDefinitionParserUtils.setPropertyValue(builder, element.getAttribute("global-scope"), "globalScope");
        BeanDefinitionParserUtils.setPropertyValue(builder, element.getAttribute("mapping-strategy"), "pathMappingStrategy");
        BeanDefinitionParserUtils.setPropertyValue(builder, element.getAttribute("direction"), "direction");
        Element mappings = DomUtils.getChildElementByTagName((Element)element, (String)"mappings");
        if (mappings != null) {
            this.parseMappingDefinitions(builder, mappings);
        }
        if ((mappingFile = DomUtils.getChildElementByTagName((Element)element, (String)"mapping-file")) != null) {
            BeanDefinitionParserUtils.setPropertyValue(builder, mappingFile.getAttribute("path"), "mappingFile");
        }
        parserContext.getRegistry().registerBeanDefinition(element.getAttribute("id"), (BeanDefinition)builder.getBeanDefinition());
        return null;
    }

    private void parseMappingDefinitions(BeanDefinitionBuilder builder, Element element) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (Element matcher : DomUtils.getChildElementsByTagName((Element)element, (String)"mapping")) {
            mappings.put(matcher.getAttribute("path"), matcher.getAttribute("value"));
        }
        if (!mappings.isEmpty()) {
            builder.addPropertyValue("mappings", mappings);
        }
    }

    protected abstract Class<? extends DataDictionary<?>> getDictionaryClass();
}

