/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.TestAction;
import com.consol.citrus.config.xml.AbstractTestContainerFactoryBean;
import com.consol.citrus.config.xml.ActionContainerParser;
import com.consol.citrus.config.xml.DescriptionElementParser;
import com.consol.citrus.container.Async;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class AsyncParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Element errorActions;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(AsyncFactoryBean.class);
        DescriptionElementParser.doParse(element, builder);
        builder.addPropertyValue("name", (Object)element.getLocalName());
        ActionContainerParser.doParse(DomUtils.getChildElementByTagName((Element)element, (String)"actions"), parserContext, builder);
        Element successActions = DomUtils.getChildElementByTagName((Element)element, (String)"success");
        if (successActions != null) {
            ActionContainerParser.doParse(successActions, parserContext, builder, "successActions");
        }
        if ((errorActions = DomUtils.getChildElementByTagName((Element)element, (String)"error")) != null) {
            ActionContainerParser.doParse(errorActions, parserContext, builder, "errorActions");
        }
        return builder.getBeanDefinition();
    }

    public static class AsyncFactoryBean
    extends AbstractTestContainerFactoryBean<Async, Async.Builder> {
        private final Async.Builder builder = new Async.Builder();
        private List<TestAction> successActions = new ArrayList<TestAction>();
        private List<TestAction> errorActions = new ArrayList<TestAction>();

        public void setSuccessActions(List<TestAction> successActions) {
            this.successActions = successActions;
        }

        public void setErrorActions(List<TestAction> errorActions) {
            this.errorActions = errorActions;
        }

        public Async getObject() throws Exception {
            this.errorActions.forEach(arg_0 -> ((Async.Builder)this.builder).errorAction(arg_0));
            this.successActions.forEach(arg_0 -> ((Async.Builder)this.builder).successAction(arg_0));
            return this.getObject(this.builder.build());
        }

        public Class<?> getObjectType() {
            return Async.class;
        }

        @Override
        public Async.Builder getBuilder() {
            return this.builder;
        }
    }
}

