/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.config.util.ValidateMessageParserUtil;
import com.consol.citrus.config.util.VariableExtractorParserUtil;
import com.consol.citrus.config.xml.AbstractMessageActionParser;
import com.consol.citrus.config.xml.AbstractReceiveMessageActionFactoryBean;
import com.consol.citrus.config.xml.DescriptionElementParser;
import com.consol.citrus.config.xml.MessageSelectorParser;
import com.consol.citrus.validation.builder.DefaultMessageBuilder;
import com.consol.citrus.validation.context.HeaderValidationContext;
import com.consol.citrus.validation.context.SchemaValidationContext;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.validation.json.JsonMessageValidationContext;
import com.consol.citrus.validation.json.JsonPathMessageValidationContext;
import com.consol.citrus.validation.script.ScriptValidationContext;
import com.consol.citrus.validation.xml.XmlMessageValidationContext;
import com.consol.citrus.validation.xml.XpathMessageValidationContext;
import com.consol.citrus.variable.VariableExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ReceiveMessageActionParser
extends AbstractMessageActionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String endpointUri = element.getAttribute("endpoint");
        if (!StringUtils.hasText((String)endpointUri)) {
            throw new BeanCreationException("Endpoint reference must not be empty");
        }
        BeanDefinitionBuilder builder = this.parseComponent(element, parserContext);
        builder.addPropertyValue("name", (Object)element.getLocalName());
        if (endpointUri.contains(":") || endpointUri.contains("${") && endpointUri.contains("}")) {
            builder.addPropertyValue("endpointUri", (Object)endpointUri);
        } else {
            builder.addPropertyReference("endpoint", endpointUri);
        }
        DescriptionElementParser.doParse(element, builder);
        BeanDefinitionParserUtils.setPropertyReference(builder, element.getAttribute("actor"), "actor");
        String receiveTimeout = element.getAttribute("timeout");
        if (StringUtils.hasText((String)receiveTimeout)) {
            builder.addPropertyValue("receiveTimeout", (Object)Long.valueOf(receiveTimeout));
        }
        MessageSelectorParser.doParse(element, builder);
        Element messageElement = DomUtils.getChildElementByTagName((Element)element, (String)"message");
        List<ValidationContext> validationContexts = this.parseValidationContexts(messageElement, builder);
        DefaultMessageBuilder messageBuilder = this.constructMessageBuilder(messageElement, builder);
        this.parseHeaderElements(element, messageBuilder, validationContexts);
        builder.addPropertyValue("messageBuilder", (Object)messageBuilder);
        builder.addPropertyValue("validationContexts", validationContexts);
        builder.addPropertyValue("variableExtractors", this.getVariableExtractors(element));
        return builder.getBeanDefinition();
    }

    protected List<ValidationContext> parseValidationContexts(Element messageElement, BeanDefinitionBuilder builder) {
        ArrayList<ValidationContext> validationContexts = new ArrayList<ValidationContext>();
        if (messageElement != null) {
            String dataDictionary;
            String messageValidatorExpression;
            ScriptValidationContext scriptValidationContext;
            String headerValidatorExpression;
            String messageType = messageElement.getAttribute("type");
            if (StringUtils.hasText((String)messageType)) {
                builder.addPropertyValue("messageType", (Object)messageType);
            }
            HeaderValidationContext headerValidationContext = new HeaderValidationContext();
            validationContexts.add((ValidationContext)headerValidationContext);
            String headerValidator = messageElement.getAttribute("header-validator");
            if (StringUtils.hasText((String)headerValidator)) {
                headerValidationContext.addHeaderValidator(headerValidator);
            }
            if (StringUtils.hasText((String)(headerValidatorExpression = messageElement.getAttribute("header-validators")))) {
                Stream.of(headerValidatorExpression.split(",")).map(String::trim).forEach(arg_0 -> ((HeaderValidationContext)headerValidationContext).addHeaderValidator(arg_0));
            }
            XmlMessageValidationContext xmlMessageValidationContext = this.getXmlMessageValidationContext(messageElement);
            validationContexts.add((ValidationContext)xmlMessageValidationContext);
            XpathMessageValidationContext xPathMessageValidationContext = this.getXPathMessageValidationContext(messageElement, xmlMessageValidationContext);
            if (!xPathMessageValidationContext.getXpathExpressions().isEmpty()) {
                validationContexts.add((ValidationContext)xPathMessageValidationContext);
            }
            JsonMessageValidationContext jsonMessageValidationContext = this.getJsonMessageValidationContext(messageElement);
            validationContexts.add((ValidationContext)jsonMessageValidationContext);
            JsonPathMessageValidationContext jsonPathMessageValidationContext = this.getJsonPathMessageValidationContext(messageElement);
            if (!jsonPathMessageValidationContext.getJsonPathExpressions().isEmpty()) {
                validationContexts.add((ValidationContext)jsonPathMessageValidationContext);
            }
            if ((scriptValidationContext = this.getScriptValidationContext(messageElement)) != null) {
                validationContexts.add((ValidationContext)scriptValidationContext);
            }
            ManagedList validators = new ManagedList();
            String messageValidator = messageElement.getAttribute("validator");
            if (StringUtils.hasText((String)messageValidator)) {
                validators.add((Object)new RuntimeBeanReference(messageValidator));
            }
            if (StringUtils.hasText((String)(messageValidatorExpression = messageElement.getAttribute("validators")))) {
                Stream.of(messageValidatorExpression.split(",")).map(String::trim).map(RuntimeBeanReference::new).forEach(arg_0 -> validators.add(arg_0));
            }
            if (!validators.isEmpty()) {
                builder.addPropertyValue("validators", (Object)validators);
            }
            if (StringUtils.hasText((String)(dataDictionary = messageElement.getAttribute("data-dictionary")))) {
                builder.addPropertyReference("dataDictionary", dataDictionary);
            }
        } else {
            validationContexts.add((ValidationContext)new HeaderValidationContext());
        }
        return validationContexts;
    }

    protected List<VariableExtractor> getVariableExtractors(Element element) {
        ArrayList<VariableExtractor> variableExtractors = new ArrayList<VariableExtractor>();
        this.parseExtractHeaderElements(element, variableExtractors);
        Element extractElement = DomUtils.getChildElementByTagName((Element)element, (String)"extract");
        if (extractElement != null) {
            HashMap<String, String> extractFromPath = new HashMap<String, String>();
            List messageValueElements = DomUtils.getChildElementsByTagName((Element)extractElement, (String)"message");
            messageValueElements.addAll(DomUtils.getChildElementsByTagName((Element)extractElement, (String)"body"));
            VariableExtractorParserUtil.parseMessageElement(messageValueElements, extractFromPath);
            if (!CollectionUtils.isEmpty(extractFromPath)) {
                VariableExtractorParserUtil.addPayloadVariableExtractors(element, variableExtractors, extractFromPath);
            }
        }
        return variableExtractors;
    }

    private JsonMessageValidationContext getJsonMessageValidationContext(Element messageElement) {
        JsonMessageValidationContext.Builder context = new JsonMessageValidationContext.Builder();
        if (messageElement != null) {
            HashSet<String> ignoreExpressions = new HashSet<String>();
            List ignoreElements = DomUtils.getChildElementsByTagName((Element)messageElement, (String)"ignore");
            for (Element ignoreValue : ignoreElements) {
                ignoreExpressions.add(ignoreValue.getAttribute("path"));
            }
            ignoreExpressions.forEach(arg_0 -> ((JsonMessageValidationContext.Builder)context).ignore(arg_0));
            this.addSchemaInformationToValidationContext(messageElement, (SchemaValidationContext.Builder<?>)context);
        }
        return context.build();
    }

    private XmlMessageValidationContext getXmlMessageValidationContext(Element messageElement) {
        XmlMessageValidationContext.Builder context = new XmlMessageValidationContext.Builder();
        if (messageElement != null) {
            this.addSchemaInformationToValidationContext(messageElement, (SchemaValidationContext.Builder<?>)context);
            HashSet<String> ignoreExpressions = new HashSet<String>();
            List ignoreElements = DomUtils.getChildElementsByTagName((Element)messageElement, (String)"ignore");
            for (Element ignoreValue : ignoreElements) {
                ignoreExpressions.add(ignoreValue.getAttribute("path"));
            }
            ignoreExpressions.forEach(arg_0 -> ((XmlMessageValidationContext.Builder)context).ignore(arg_0));
            this.parseNamespaceValidationElements(messageElement, context);
            HashMap<String, String> namespaces = new HashMap<String, String>();
            List namespaceElements = DomUtils.getChildElementsByTagName((Element)messageElement, (String)"namespace");
            if (namespaceElements.size() > 0) {
                for (Element namespaceElement : namespaceElements) {
                    namespaces.put(namespaceElement.getAttribute("prefix"), namespaceElement.getAttribute("value"));
                }
                context.setNamespaces(namespaces);
            }
        }
        return context.build();
    }

    private void addSchemaInformationToValidationContext(Element messageElement, SchemaValidationContext.Builder<?> context) {
        String schemaRepository;
        String schema;
        String schemaValidation = messageElement.getAttribute("schema-validation");
        if (StringUtils.hasText((String)schemaValidation)) {
            context.schemaValidation(Boolean.valueOf(schemaValidation).booleanValue());
        }
        if (StringUtils.hasText((String)(schema = messageElement.getAttribute("schema")))) {
            context.schema(schema);
        }
        if (StringUtils.hasText((String)(schemaRepository = messageElement.getAttribute("schema-repository")))) {
            context.schemaRepository(schemaRepository);
        }
    }

    private XpathMessageValidationContext getXPathMessageValidationContext(Element messageElement, XmlMessageValidationContext parentContext) {
        XpathMessageValidationContext.Builder context = new XpathMessageValidationContext.Builder();
        this.parseXPathValidationElements(messageElement, context);
        context.setNamespaces(parentContext.getNamespaces());
        context.namespaces(parentContext.getControlNamespaces());
        parentContext.getIgnoreExpressions().forEach(arg_0 -> ((XpathMessageValidationContext.Builder)context).ignore(arg_0));
        context.schema(parentContext.getSchema());
        context.schemaRepository(parentContext.getSchemaRepository());
        context.schemaValidation(parentContext.isSchemaValidationEnabled());
        context.dtd(parentContext.getDTDResource());
        return context.build();
    }

    private JsonPathMessageValidationContext getJsonPathMessageValidationContext(Element messageElement) {
        JsonPathMessageValidationContext.Builder context = new JsonPathMessageValidationContext.Builder();
        HashMap<String, Object> validateJsonPathExpressions = new HashMap<String, Object>();
        List validateElements = DomUtils.getChildElementsByTagName((Element)messageElement, (String)"validate");
        if (validateElements.size() > 0) {
            for (Element validateElement : validateElements) {
                this.extractJsonPathValidateExpressions(validateElement, validateJsonPathExpressions);
            }
            context.expressions(validateJsonPathExpressions);
        }
        return context.build();
    }

    private ScriptValidationContext getScriptValidationContext(Element messageElement) {
        boolean done = false;
        List validateElements = DomUtils.getChildElementsByTagName((Element)messageElement, (String)"validate");
        if (validateElements.size() > 0) {
            for (Element validateElement : validateElements) {
                Element scriptElement = DomUtils.getChildElementByTagName((Element)validateElement, (String)"script");
                if (scriptElement == null) continue;
                if (done) {
                    throw new BeanCreationException("Found multiple validation script definitions - only supporting a single validation script for message validation");
                }
                done = true;
                String type = scriptElement.getAttribute("type");
                ScriptValidationContext.Builder context = new ScriptValidationContext.Builder().scriptType(type);
                String filePath = scriptElement.getAttribute("file");
                if (StringUtils.hasText((String)filePath)) {
                    context.scriptResource(filePath);
                    if (scriptElement.hasAttribute("charset")) {
                        context.scriptResourceCharset(scriptElement.getAttribute("charset"));
                    }
                } else {
                    context.script(DomUtils.getTextValue((Element)scriptElement));
                }
                return context.build();
            }
        }
        return null;
    }

    private void parseNamespaceValidationElements(Element messageElement, XmlMessageValidationContext.Builder context) {
        HashMap<String, String> validateNamespaces = new HashMap<String, String>();
        List validateElements = DomUtils.getChildElementsByTagName((Element)messageElement, (String)"validate");
        if (validateElements.size() > 0) {
            for (Element validateElement : validateElements) {
                List validateNamespaceElements = DomUtils.getChildElementsByTagName((Element)validateElement, (String)"namespace");
                if (validateNamespaceElements.size() <= 0) continue;
                for (Element namespaceElement : validateNamespaceElements) {
                    validateNamespaces.put(namespaceElement.getAttribute("prefix"), namespaceElement.getAttribute("value"));
                }
            }
            context.namespaces(validateNamespaces);
        }
    }

    private void parseXPathValidationElements(Element messageElement, XpathMessageValidationContext.Builder context) {
        HashMap<String, Object> validateXpathExpressions = new HashMap<String, Object>();
        List validateElements = DomUtils.getChildElementsByTagName((Element)messageElement, (String)"validate");
        if (validateElements.size() > 0) {
            for (Element validateElement : validateElements) {
                this.extractXPathValidateExpressions(validateElement, validateXpathExpressions);
            }
            context.expressions(validateXpathExpressions);
        }
    }

    private void extractXPathValidateExpressions(Element validateElement, Map<String, Object> validateXpathExpressions) {
        List xpathElements;
        String pathExpression = validateElement.getAttribute("path");
        if (StringUtils.hasText((String)pathExpression) && !JsonPathMessageValidationContext.isJsonPathExpression((String)pathExpression)) {
            if (validateElement.hasAttribute("result-type")) {
                pathExpression = validateElement.getAttribute("result-type") + ":" + pathExpression;
            }
            validateXpathExpressions.put(pathExpression, validateElement.getAttribute("value"));
        }
        if ((xpathElements = DomUtils.getChildElementsByTagName((Element)validateElement, (String)"xpath")).size() > 0) {
            for (Element xpathElement : xpathElements) {
                String expression = xpathElement.getAttribute("expression");
                if (!StringUtils.hasText((String)expression)) continue;
                if (xpathElement.hasAttribute("result-type")) {
                    expression = xpathElement.getAttribute("result-type") + ":" + expression;
                }
                validateXpathExpressions.put(expression, xpathElement.getAttribute("value"));
            }
        }
    }

    private void extractJsonPathValidateExpressions(Element validateElement, Map<String, Object> validateJsonPathExpressions) {
        String pathExpression = validateElement.getAttribute("path");
        if (JsonPathMessageValidationContext.isJsonPathExpression((String)pathExpression)) {
            validateJsonPathExpressions.put(pathExpression, validateElement.getAttribute("value"));
        }
        ValidateMessageParserUtil.parseJsonPathElements(validateElement, validateJsonPathExpressions);
    }

    protected BeanDefinitionBuilder parseComponent(Element element, ParserContext parserContext) {
        return BeanDefinitionBuilder.genericBeanDefinition(ReceiveMessageActionFactoryBean.class);
    }

    public static class ReceiveMessageActionFactoryBean
    extends AbstractReceiveMessageActionFactoryBean<ReceiveMessageAction, ReceiveMessageAction.ReceiveMessageActionBuilderSupport, ReceiveMessageAction.Builder> {
        private final ReceiveMessageAction.Builder builder = new ReceiveMessageAction.Builder();

        public ReceiveMessageAction getObject() throws Exception {
            return this.builder.build();
        }

        public Class<?> getObjectType() {
            return ReceiveMessageAction.class;
        }

        @Override
        public ReceiveMessageAction.Builder getBuilder() {
            return this.builder;
        }
    }
}

