/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.spi.ResourcePathTypeResolver;
import com.consol.citrus.util.FileUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SchemaParser
implements BeanDefinitionParser {
    private static Logger log = LoggerFactory.getLogger(SchemaParser.class);
    private static final String RESOURCE_PATH = "META-INF/citrus/schema/parser";
    private static final ResourcePathTypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/schema/parser");
    private static final Map<String, BeanDefinitionParser> PARSER_CACHE = new HashMap<String, BeanDefinitionParser>();

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String location = element.getAttribute("location");
        return this.lookupSchemaParser(location).parse(element, parserContext);
    }

    private BeanDefinitionParser lookupSchemaParser(String location) {
        String fileExtension = FileUtils.getFileExtension((String)location);
        if (PARSER_CACHE.containsKey(fileExtension)) {
            return PARSER_CACHE.get(fileExtension);
        }
        BeanDefinitionParser parser = (BeanDefinitionParser)TYPE_RESOLVER.resolve(fileExtension, new Object[0]);
        log.info(String.format("Found schema bean definition parser %s from resource %s", parser.getClass(), "META-INF/citrus/schema/parser/" + fileExtension));
        PARSER_CACHE.put(fileExtension, parser);
        return parser;
    }
}

