/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus;

import com.consol.citrus.CitrusContext;
import com.consol.citrus.config.CitrusSpringConfig;
import com.consol.citrus.container.AfterSuite;
import com.consol.citrus.container.BeforeSuite;
import com.consol.citrus.context.TestContextFactory;
import com.consol.citrus.context.TestContextFactoryBean;
import com.consol.citrus.functions.FunctionRegistry;
import com.consol.citrus.report.MessageListeners;
import com.consol.citrus.report.TestActionListeners;
import com.consol.citrus.report.TestListeners;
import com.consol.citrus.report.TestReporters;
import com.consol.citrus.report.TestSuiteListeners;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.util.TypeConverter;
import com.consol.citrus.validation.MessageValidatorRegistry;
import com.consol.citrus.validation.matcher.ValidationMatcherRegistry;
import java.util.ArrayList;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class CitrusSpringContext
extends CitrusContext {
    private final ApplicationContext applicationContext;

    protected CitrusSpringContext(Builder builder) {
        super((CitrusContext.Builder)builder);
        this.applicationContext = builder.applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void close() {
        if (this.applicationContext instanceof ConfigurableApplicationContext && ((ConfigurableApplicationContext)this.applicationContext).isActive()) {
            ((ConfigurableApplicationContext)this.applicationContext).close();
        }
    }

    public static CitrusSpringContext create() {
        return CitrusSpringContext.create((ApplicationContext)new AnnotationConfigApplicationContext(new Class[]{CitrusSpringConfig.class}));
    }

    public static CitrusSpringContext create(Class<? extends CitrusSpringConfig> configClass) {
        return CitrusSpringContext.create((ApplicationContext)new AnnotationConfigApplicationContext(new Class[]{configClass}));
    }

    public static CitrusSpringContext create(ApplicationContext applicationContext) {
        return new Builder().withApplicationContext(applicationContext).build();
    }

    public static final class Builder
    extends CitrusContext.Builder {
        private ApplicationContext applicationContext;

        public Builder withApplicationContext(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
            this.functionRegistry((FunctionRegistry)applicationContext.getBean(FunctionRegistry.class));
            this.validationMatcherRegistry((ValidationMatcherRegistry)applicationContext.getBean(ValidationMatcherRegistry.class));
            this.messageValidatorRegistry((MessageValidatorRegistry)applicationContext.getBean(MessageValidatorRegistry.class));
            this.messageListeners((MessageListeners)applicationContext.getBean(MessageListeners.class));
            this.testListeners((TestListeners)applicationContext.getBean(TestListeners.class));
            this.testActionListeners((TestActionListeners)applicationContext.getBean(TestActionListeners.class));
            this.testReporters((TestReporters)applicationContext.getBean(TestReporters.class));
            this.testSuiteListeners((TestSuiteListeners)applicationContext.getBean(TestSuiteListeners.class));
            this.testContextFactory((TestContextFactory)applicationContext.getBean(TestContextFactoryBean.class));
            this.referenceResolver((ReferenceResolver)applicationContext.getBean(ReferenceResolver.class));
            this.typeConverter((TypeConverter)applicationContext.getBean(TypeConverter.class));
            this.beforeSuite(new ArrayList(applicationContext.getBeansOfType(BeforeSuite.class).values()));
            this.afterSuite(new ArrayList(applicationContext.getBeansOfType(AfterSuite.class).values()));
            return this;
        }

        public CitrusSpringContext build() {
            return new CitrusSpringContext(this);
        }
    }
}

