/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.common;

import com.consol.citrus.CitrusContext;
import com.consol.citrus.CitrusSpringContext;
import com.consol.citrus.DefaultTestCase;
import com.consol.citrus.TestCase;
import com.consol.citrus.common.TestLoader;
import java.io.File;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.StringUtils;

public class XmlTestLoader
implements TestLoader {
    private TestCase testCase;
    private Class<?> testClass;
    private String testName;
    private String packageName;
    private CitrusContext citrusContext;
    private String contextFile;

    public XmlTestLoader(Class<?> testClass, String testName, String packageName, CitrusContext citrusContext) {
        this.testClass = testClass;
        this.testName = testName;
        this.packageName = packageName;
        this.citrusContext = citrusContext;
    }

    public TestCase load() {
        if (this.testCase == null) {
            ApplicationContext ctx = this.loadApplicationContext();
            try {
                this.testCase = (TestCase)ctx.getBean(this.testName, TestCase.class);
                if (this.testCase instanceof DefaultTestCase) {
                    this.testCase.setTestClass(this.testClass);
                    this.testCase.setPackageName(this.packageName);
                }
            }
            catch (NoSuchBeanDefinitionException e) {
                throw this.citrusContext.getTestContextFactory().getObject().handleError(this.testName, this.packageName, "Could not find test with name '" + this.testName + "'", (Exception)((Object)e));
            }
        }
        return this.testCase;
    }

    private ApplicationContext loadApplicationContext() {
        try {
            return new ClassPathXmlApplicationContext(new String[]{this.getContextFile(), "com/consol/citrus/spring/annotation-config-ctx.xml"}, true, this.getParentApplicationContext());
        }
        catch (Exception e) {
            throw this.citrusContext.getTestContextFactory().getObject().handleError(this.testName, this.packageName, "Failed to load test case", e);
        }
    }

    private ApplicationContext getParentApplicationContext() {
        if (this.citrusContext instanceof CitrusSpringContext) {
            return ((CitrusSpringContext)this.citrusContext).getApplicationContext();
        }
        return null;
    }

    public String getContextFile() {
        if (StringUtils.hasText((String)this.contextFile)) {
            return this.contextFile;
        }
        return this.packageName.replace('.', File.separatorChar) + File.separator + this.testName + ".xml";
    }

    public void setContextFile(String contextFile) {
        this.contextFile = contextFile;
    }
}

