/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.config.xml.SchemaParser;
import com.consol.citrus.spi.ResourcePathTypeResolver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SchemaRepositoryParser
implements BeanDefinitionParser {
    private static Logger log = LoggerFactory.getLogger(SchemaRepositoryParser.class);
    private static final String LOCATION = "location";
    private static final String LOCATIONS = "locations";
    private static final String SCHEMA = "schema";
    private static final String SCHEMAS = "schemas";
    private static final String ID = "id";
    private static final SchemaParser SCHEMA_PARSER = new SchemaParser();
    private static final String RESOURCE_PATH = "META-INF/citrus/schema-repository/parser";
    private static final ResourcePathTypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/schema-repository/parser");
    private static final Map<String, BeanDefinitionParser> SCHEMA_REPOSITORY_PARSER = new HashMap<String, BeanDefinitionParser>();

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String schemaRepositoryType = element.getAttribute("type");
        if (StringUtils.isEmpty((Object)schemaRepositoryType)) {
            schemaRepositoryType = "xml";
        }
        return this.lookupSchemaRepositoryParser(schemaRepositoryType).parse(element, parserContext);
    }

    private BeanDefinitionParser lookupSchemaRepositoryParser(String type) {
        if (SCHEMA_REPOSITORY_PARSER.containsKey(type)) {
            return SCHEMA_REPOSITORY_PARSER.get(type);
        }
        BeanDefinitionParser parser = (BeanDefinitionParser)TYPE_RESOLVER.resolve(type, new Object[0]);
        log.info(String.format("Found schema repository bean definition parser %s from resource %s", parser.getClass(), "META-INF/citrus/schema-repository/parser/" + type));
        SCHEMA_REPOSITORY_PARSER.put(type, parser);
        return parser;
    }

    static void addLocationsToBuilder(Element element, BeanDefinitionBuilder builder) {
        List locationElements;
        List locations;
        Element locationsElement = DomUtils.getChildElementByTagName((Element)element, (String)LOCATIONS);
        if (locationsElement != null && !(locations = (locationElements = DomUtils.getChildElementsByTagName((Element)locationsElement, (String)LOCATION)).stream().map(locationElement -> locationElement.getAttribute("path")).collect(Collectors.toList())).isEmpty()) {
            builder.addPropertyValue(LOCATIONS, locations);
        }
    }

    static void parseSchemasElement(Element element, BeanDefinitionBuilder builder, ParserContext parserContext) {
        List schemaElements;
        ManagedList<RuntimeBeanReference> beanReferences;
        Element schemasElement = DomUtils.getChildElementByTagName((Element)element, (String)SCHEMAS);
        if (schemasElement != null && !(beanReferences = SchemaRepositoryParser.constructRuntimeBeanReferences(parserContext, schemaElements = DomUtils.getChildElements((Element)schemasElement))).isEmpty()) {
            builder.addPropertyValue(SCHEMAS, beanReferences);
        }
    }

    private static ManagedList<RuntimeBeanReference> constructRuntimeBeanReferences(ParserContext parserContext, List<Element> schemaElements) {
        ManagedList runtimeBeanReferences = new ManagedList();
        for (Element schemaElement : schemaElements) {
            if (schemaElement.hasAttribute(SCHEMA)) {
                runtimeBeanReferences.add((Object)new RuntimeBeanReference(schemaElement.getAttribute(SCHEMA)));
                continue;
            }
            SCHEMA_PARSER.parse(schemaElement, parserContext);
            runtimeBeanReferences.add((Object)new RuntimeBeanReference(schemaElement.getAttribute(ID)));
        }
        return runtimeBeanReferences;
    }
}

