/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config;

import com.consol.citrus.common.InitializingPhase;
import com.consol.citrus.common.Named;
import com.consol.citrus.common.ShutdownPhase;
import com.consol.citrus.context.SpringBeanReferenceResolver;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ComponentLifecycleProcessor
implements DestructionAwareBeanPostProcessor,
ApplicationContextAware {
    private ReferenceResolver referenceResolver;
    private static final Logger LOG = LoggerFactory.getLogger(ComponentLifecycleProcessor.class);

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Named) {
            ((Named)bean).setName(beanName);
        }
        if (bean instanceof ReferenceResolverAware) {
            ((ReferenceResolverAware)bean).setReferenceResolver(this.referenceResolver);
        }
        if (bean instanceof InitializingPhase) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Initializing component '%s'", beanName));
            }
            ((InitializingPhase)bean).initialize();
        }
        return bean;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (this.requiresDestruction(bean)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Destroying component '%s'", beanName));
            }
            ((ShutdownPhase)bean).destroy();
        }
    }

    public boolean requiresDestruction(Object bean) {
        return bean instanceof ShutdownPhase;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.referenceResolver = applicationContext.getBeansOfType(ReferenceResolver.class).size() == 1 ? (ReferenceResolver)applicationContext.getBean(ReferenceResolver.class) : new SpringBeanReferenceResolver(applicationContext);
    }
}

