/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.config.xml.ActionContainerParser;
import com.consol.citrus.container.AbstractTestBoundaryActionContainer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractTestBoundaryActionContainerParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(this.getContainerClass());
        builder.addPropertyValue("name", (Object)element.getAttribute("id"));
        BeanDefinitionParserUtils.setPropertyValue(builder, element.getAttribute("test"), "namePattern");
        BeanDefinitionParserUtils.setPropertyValue(builder, element.getAttribute("package"), "packageNamePattern");
        if (element.hasAttribute("groups")) {
            List<String> groups = Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)element.getAttribute("groups")));
            builder.addPropertyValue("testGroups", groups);
        }
        HashMap<String, String> envProperties = new HashMap<String, String>();
        Element envElement = DomUtils.getChildElementByTagName((Element)element, (String)"env");
        if (envElement != null) {
            List propertyElements = DomUtils.getChildElementsByTagName((Element)envElement, (String)"property");
            for (Element property : propertyElements) {
                envProperties.put(property.getAttribute("name"), property.getAttribute("value"));
            }
        }
        if (!envProperties.isEmpty()) {
            builder.addPropertyValue("env", envProperties);
        }
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        Element systemElement = DomUtils.getChildElementByTagName((Element)element, (String)"system");
        if (systemElement != null) {
            List propertyElements = DomUtils.getChildElementsByTagName((Element)systemElement, (String)"property");
            for (Element property : propertyElements) {
                systemProperties.put(property.getAttribute("name"), property.getAttribute("value"));
            }
        }
        if (!systemProperties.isEmpty()) {
            builder.addPropertyValue("systemProperties", systemProperties);
        }
        ActionContainerParser.doParse(DomUtils.getChildElementByTagName((Element)element, (String)"actions"), parserContext, builder);
        parserContext.getRegistry().registerBeanDefinition(element.getAttribute("id"), (BeanDefinition)builder.getBeanDefinition());
        return null;
    }

    protected abstract Class<? extends AbstractTestBoundaryActionContainer> getContainerClass();
}

