/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.actions.CreateVariablesAction;
import com.consol.citrus.config.xml.AbstractTestActionFactoryBean;
import com.consol.citrus.config.xml.DescriptionElementParser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CreateVariablesActionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(CreateVariablesActionFactoryBean.class);
        DescriptionElementParser.doParse(element, beanDefinition);
        LinkedHashMap<String, Object> variables = new LinkedHashMap<String, Object>();
        List variableElements = DomUtils.getChildElementsByTagName((Element)element, (String)"variable");
        for (Element variable : variableElements) {
            Element variableData;
            Element variableValueElement = DomUtils.getChildElementByTagName((Element)variable, (String)"value");
            if (variableValueElement == null) {
                variables.put(variable.getAttribute("name"), variable.getAttribute("value"));
                continue;
            }
            Element variableScript = DomUtils.getChildElementByTagName((Element)variableValueElement, (String)"script");
            if (variableScript != null) {
                String scriptEngine = variableScript.getAttribute("type");
                variables.put(variable.getAttribute("name"), "script:<" + scriptEngine + ">" + variableScript.getTextContent());
            }
            if ((variableData = DomUtils.getChildElementByTagName((Element)variableValueElement, (String)"data")) == null) continue;
            variables.put(variable.getAttribute("name"), DomUtils.getTextValue((Element)variableData).trim());
        }
        beanDefinition.addPropertyValue("variables", variables);
        return beanDefinition.getBeanDefinition();
    }

    public static class CreateVariablesActionFactoryBean
    extends AbstractTestActionFactoryBean<CreateVariablesAction, CreateVariablesAction.Builder> {
        private final CreateVariablesAction.Builder builder = new CreateVariablesAction.Builder();

        public CreateVariablesAction getObject() throws Exception {
            return this.builder.build();
        }

        public void setVariables(Map<String, String> variables) {
            variables.forEach((arg_0, arg_1) -> ((CreateVariablesAction.Builder)this.builder).variable(arg_0, arg_1));
        }

        public Class<?> getObjectType() {
            return CreateVariablesAction.class;
        }

        @Override
        public CreateVariablesAction.Builder getBuilder() {
            return this.builder;
        }
    }
}

