/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.TestAction;
import com.consol.citrus.condition.ActionCondition;
import com.consol.citrus.condition.Condition;
import com.consol.citrus.condition.FileCondition;
import com.consol.citrus.condition.HttpCondition;
import com.consol.citrus.condition.MessageCondition;
import com.consol.citrus.config.TestActionRegistry;
import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.config.xml.AbstractTestActionFactoryBean;
import com.consol.citrus.config.xml.DescriptionElementParser;
import com.consol.citrus.container.Wait;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import org.apache.xerces.util.DOMUtil;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WaitParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(WaitFactoryBean.class);
        DescriptionElementParser.doParse(element, builder);
        BeanDefinitionParserUtils.setPropertyValue(builder, element.getAttribute("seconds"), "seconds");
        BeanDefinitionParserUtils.setPropertyValue(builder, element.getAttribute("milliseconds"), "milliseconds");
        BeanDefinitionParserUtils.setPropertyValue(builder, element.getAttribute("interval"), "interval");
        Element conditionElement = DOMUtil.getFirstChildElement((Node)element);
        if (conditionElement != null && conditionElement.getTagName().equals("description")) {
            conditionElement = DOMUtil.getNextSiblingElement((Node)conditionElement);
        }
        if (conditionElement == null) {
            throw new CitrusRuntimeException("Invalid 'wait' action configuration. No 'condition' is configured");
        }
        String conditionName = conditionElement.getTagName();
        Condition condition = null;
        switch (conditionName) {
            case "http": {
                condition = this.parseHttpCondition(conditionElement);
                break;
            }
            case "file": {
                condition = this.parseFileCondition(conditionElement);
                break;
            }
            case "message": {
                condition = this.parseMessageCondition(conditionElement);
                break;
            }
            case "action": {
                builder.addPropertyValue("action", (Object)this.parseActionCondition(conditionElement, parserContext));
                break;
            }
            default: {
                throw new CitrusRuntimeException(String.format("Invalid 'wait' action configuration. Unknown condition '%s'", conditionName));
            }
        }
        if (condition != null) {
            builder.addPropertyValue("condition", (Object)condition);
        }
        return builder.getBeanDefinition();
    }

    private Condition parseHttpCondition(Element element) {
        String timeout;
        String statusCode;
        HttpCondition condition = new HttpCondition();
        condition.setUrl(element.getAttribute("url"));
        String method = element.getAttribute("method");
        if (StringUtils.hasText((String)method)) {
            condition.setMethod(method);
        }
        if (StringUtils.hasText((String)(statusCode = element.getAttribute("status")))) {
            condition.setHttpResponseCode(statusCode);
        }
        if (StringUtils.hasText((String)(timeout = element.getAttribute("timeout")))) {
            condition.setTimeout(timeout);
        }
        return condition;
    }

    private Condition parseMessageCondition(Element element) {
        MessageCondition condition = new MessageCondition();
        condition.setMessageName(element.getAttribute("name"));
        return condition;
    }

    private BeanDefinition parseActionCondition(Element element, ParserContext parserContext) {
        Element action = DOMUtil.getFirstChildElement((Node)element);
        if (action != null) {
            BeanDefinitionParser parser = null;
            if (action.getNamespaceURI().equals(element.getNamespaceURI())) {
                parser = TestActionRegistry.getActionParser(action.getLocalName());
            }
            if (parser == null) {
                return parserContext.getReaderContext().getNamespaceHandlerResolver().resolve(action.getNamespaceURI()).parse(action, parserContext);
            }
            return parser.parse(action, parserContext);
        }
        throw new BeanCreationException("Invalid wait for action condition - action not set properly");
    }

    private Condition parseFileCondition(Element element) {
        FileCondition condition = new FileCondition();
        condition.setFilePath(element.getAttribute("path"));
        return condition;
    }

    public static class WaitFactoryBean
    extends AbstractTestActionFactoryBean<Wait, Wait.Builder> {
        private final Wait.Builder builder = new Wait.Builder();

        public void setCondition(Condition condition) {
            this.builder.condition(condition);
        }

        public void setInterval(Long interval) {
            this.builder.interval(interval);
        }

        public void setMilliseconds(Long milliseconds) {
            this.builder.milliseconds(milliseconds.longValue());
        }

        public void setSeconds(Double seconds) {
            this.builder.seconds(seconds.doubleValue());
        }

        public void setAction(TestAction action) {
            this.builder.condition((Condition)new ActionCondition(action));
        }

        public Wait getObject() throws Exception {
            return this.builder.build();
        }

        public Class<?> getObjectType() {
            return Wait.class;
        }

        @Override
        public Wait.Builder getBuilder() {
            return this.builder;
        }
    }
}

