/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message;

import com.consol.citrus.builder.WithExpressions;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageProcessor;
import com.consol.citrus.validation.json.JsonPathMessageValidationContext;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class DelegatingPathExpressionProcessor
implements MessageProcessor {
    private final Map<String, Object> pathExpressions;

    public DelegatingPathExpressionProcessor() {
        this(new HashMap<String, Object>());
    }

    public DelegatingPathExpressionProcessor(Map<String, Object> pathExpressions) {
        this.pathExpressions = pathExpressions;
    }

    public void process(Message message, TestContext context) {
        if (CollectionUtils.isEmpty(this.pathExpressions)) {
            return;
        }
        LinkedHashMap<String, Object> jsonPathExpressions = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> xpathExpressions = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> pathExpression : this.pathExpressions.entrySet()) {
            String path = context.replaceDynamicContentInString(pathExpression.getKey());
            Object variable = pathExpression.getValue();
            if (JsonPathMessageValidationContext.isJsonPathExpression((String)path)) {
                jsonPathExpressions.put(path, variable);
                continue;
            }
            xpathExpressions.put(path, variable);
        }
        if (!jsonPathExpressions.isEmpty()) {
            MessageProcessor.Builder jsonPathProcessor = (MessageProcessor.Builder)MessageProcessor.lookup((String)"jsonPath").orElseThrow(() -> new CitrusRuntimeException("Missing proper Json Path extractor implementation for resource 'jsonPath' - consider adding proper json validation module to the project"));
            if (jsonPathProcessor instanceof WithExpressions) {
                ((WithExpressions)jsonPathProcessor).expressions(jsonPathExpressions);
            }
            jsonPathProcessor.build().process(message, context);
        }
        if (!xpathExpressions.isEmpty()) {
            MessageProcessor.Builder xpathProcessor = (MessageProcessor.Builder)MessageProcessor.lookup((String)"xpath").orElseThrow(() -> new CitrusRuntimeException("Missing proper Xpath extractor implementation for resource 'xpath' - consider adding proper xml validation module to the project"));
            if (xpathProcessor instanceof WithExpressions) {
                ((WithExpressions)xpathProcessor).expressions(xpathExpressions);
            }
            xpathProcessor.build().process(message, context);
        }
    }

    public Map<String, Object> getPathExpressions() {
        return this.pathExpressions;
    }
}

