/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation;

import com.consol.citrus.validation.DefaultMessageValidatorRegistry;
import com.consol.citrus.validation.MessageValidator;
import com.consol.citrus.validation.MessageValidatorRegistry;
import com.consol.citrus.validation.MessageValidatorRegistryFactory;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MessageValidatorConfig {
    private static final MessageValidatorRegistry MESSAGE_VALIDATOR_REGISTRY = new DefaultMessageValidatorRegistry();

    @Bean
    public static BeanDefinitionRegistryPostProcessor messageValidatorRegistrationProcessor() {
        return new BeanDefinitionRegistryPostProcessor(){

            public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
                for (Map.Entry entry : MESSAGE_VALIDATOR_REGISTRY.getMessageValidators().entrySet()) {
                    if (registry.containsBeanDefinition((String)entry.getKey())) continue;
                    MessageValidator messageValidator = (MessageValidator)entry.getValue();
                    Supplier<MessageValidator> supplier = () -> messageValidator;
                    registry.registerBeanDefinition((String)entry.getKey(), (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(MessageValidator.class, supplier).getBeanDefinition());
                }
            }

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            }
        };
    }

    @Bean(name={"citrusMessageValidatorRegistry"})
    public MessageValidatorRegistryFactory messageValidatorRegistry() {
        return new MessageValidatorRegistryFactory(MESSAGE_VALIDATOR_REGISTRY);
    }
}

