/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.common;

import com.consol.citrus.CitrusContext;
import com.consol.citrus.CitrusSpringContext;
import com.consol.citrus.DefaultTestCase;
import com.consol.citrus.TestCase;
import com.consol.citrus.common.TestLoader;
import com.consol.citrus.common.TestSourceAware;
import java.io.File;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.StringUtils;

public class XmlTestLoader
implements TestLoader,
TestSourceAware {
    private TestCase testCase;
    private final Class<?> testClass;
    private final String testName;
    private final String packageName;
    private final CitrusContext citrusContext;
    private String source;

    public XmlTestLoader(Class<?> testClass, String testName, String packageName, CitrusContext citrusContext) {
        this.testClass = testClass;
        this.testName = testName;
        this.packageName = packageName;
        this.citrusContext = citrusContext;
    }

    public TestCase load() {
        if (this.testCase == null) {
            ApplicationContext ctx = this.loadApplicationContext();
            try {
                this.testCase = (TestCase)ctx.getBean(this.testName, TestCase.class);
                if (this.testCase instanceof DefaultTestCase) {
                    this.testCase.setTestClass(this.testClass);
                    this.testCase.setPackageName(this.packageName);
                }
            }
            catch (NoSuchBeanDefinitionException e) {
                throw this.citrusContext.getTestContextFactory().getObject().handleError(this.testName, this.packageName, "Could not find test with name '" + this.testName + "'", (Exception)((Object)e));
            }
        }
        return this.testCase;
    }

    private ApplicationContext loadApplicationContext() {
        try {
            return new ClassPathXmlApplicationContext(new String[]{this.getSource(), "com/consol/citrus/spring/annotation-config-ctx.xml"}, true, this.getParentApplicationContext());
        }
        catch (Exception e) {
            throw this.citrusContext.getTestContextFactory().getObject().handleError(this.testName, this.packageName, "Failed to load test case", e);
        }
    }

    private ApplicationContext getParentApplicationContext() {
        if (this.citrusContext instanceof CitrusSpringContext) {
            return ((CitrusSpringContext)this.citrusContext).getApplicationContext();
        }
        return null;
    }

    public String getSource() {
        if (StringUtils.hasText((String)this.source)) {
            return this.source;
        }
        return this.packageName.replace('.', File.separatorChar) + File.separator + this.testName + ".xml";
    }

    public void setSource(String source) {
        this.source = source;
    }
}

