/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.endpoint.adapter.mapping;

import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.endpoint.adapter.mapping.EndpointAdapterMappingStrategy;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.util.Assert;

public class ContextLoadingMappingStrategy
implements EndpointAdapterMappingStrategy {
    protected String contextConfigLocation;
    protected boolean loadOnce = true;
    private ApplicationContext applicationContext;

    public EndpointAdapter getEndpointAdapter(String mappingKey) {
        ApplicationContext ctx;
        Assert.notNull((Object)this.contextConfigLocation, (String)"Spring bean application context location must be set properly");
        if (this.loadOnce) {
            if (this.applicationContext == null) {
                this.applicationContext = this.createApplicationContext();
            }
            ctx = this.applicationContext;
        } else {
            ctx = this.createApplicationContext();
        }
        try {
            return (EndpointAdapter)ctx.getBean(mappingKey, EndpointAdapter.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new CitrusRuntimeException("Unable to find matching endpoint adapter with bean name '" + mappingKey + "' in Spring bean application context", (Throwable)e);
        }
    }

    private ApplicationContext createApplicationContext() {
        if (this.contextConfigLocation.startsWith("classpath")) {
            return new ClassPathXmlApplicationContext(this.contextConfigLocation);
        }
        return new FileSystemXmlApplicationContext(this.contextConfigLocation);
    }

    public void setContextConfigLocation(String contextConfigLocation) {
        this.contextConfigLocation = contextConfigLocation;
    }
}

