/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.TestCaseMetaInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class BaseTestCaseMetaInfoParser<T extends TestCaseMetaInfo>
implements BeanDefinitionParser {
    private final Class<T> metaInfoType;

    protected BaseTestCaseMetaInfoParser(Class<T> metaInfoType) {
        this.metaInfoType = metaInfoType;
    }

    public BeanDefinition parse(Element metaInfoElement, ParserContext parserContext) {
        BeanDefinitionBuilder metaInfoBuilder = BeanDefinitionBuilder.rootBeanDefinition(this.metaInfoType);
        Element authorElement = DomUtils.getChildElementByTagName((Element)metaInfoElement, (String)"author");
        Element creationDateElement = DomUtils.getChildElementByTagName((Element)metaInfoElement, (String)"creationdate");
        Element statusElement = DomUtils.getChildElementByTagName((Element)metaInfoElement, (String)"status");
        Element lastUpdatedByElement = DomUtils.getChildElementByTagName((Element)metaInfoElement, (String)"last-updated-by");
        Element lastUpdatedOnElement = DomUtils.getChildElementByTagName((Element)metaInfoElement, (String)"last-updated-on");
        metaInfoBuilder.addPropertyValue("author", (Object)DomUtils.getTextValue((Element)authorElement));
        try {
            metaInfoBuilder.addPropertyValue("creationDate", (Object)new SimpleDateFormat("yyyy-MM-dd").parse(DomUtils.getTextValue((Element)creationDateElement)));
        }
        catch (ParseException e) {
            throw new BeanCreationException("Unable to parse creation date", (Throwable)e);
        }
        String status = DomUtils.getTextValue((Element)statusElement);
        if (status.equals("DRAFT")) {
            metaInfoBuilder.addPropertyValue("status", (Object)TestCaseMetaInfo.Status.DRAFT);
        } else if (status.equals("READY_FOR_REVIEW")) {
            metaInfoBuilder.addPropertyValue("status", (Object)TestCaseMetaInfo.Status.READY_FOR_REVIEW);
        } else if (status.equals("FINAL")) {
            metaInfoBuilder.addPropertyValue("status", (Object)TestCaseMetaInfo.Status.FINAL);
        } else if (status.equals("DISABLED")) {
            metaInfoBuilder.addPropertyValue("status", (Object)TestCaseMetaInfo.Status.DISABLED);
        }
        if (lastUpdatedByElement != null) {
            metaInfoBuilder.addPropertyValue("lastUpdatedBy", (Object)DomUtils.getTextValue((Element)lastUpdatedByElement));
        }
        if (lastUpdatedOnElement != null) {
            try {
                metaInfoBuilder.addPropertyValue("lastUpdatedOn", (Object)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(DomUtils.getTextValue((Element)lastUpdatedOnElement)));
            }
            catch (ParseException e) {
                throw new BeanCreationException("Unable to parse lastupdate date", (Throwable)e);
            }
        }
        this.parseAdditionalProperties(metaInfoElement, metaInfoBuilder);
        return metaInfoBuilder.getBeanDefinition();
    }

    protected void parseAdditionalProperties(Element metaInfoElement, BeanDefinitionBuilder metaInfoBuilder) {
    }
}

