/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus;

import com.consol.citrus.CitrusContext;
import com.consol.citrus.config.CitrusSpringConfig;
import com.consol.citrus.container.AfterSuite;
import com.consol.citrus.container.BeforeSuite;
import com.consol.citrus.context.TestContextFactoryBean;
import com.consol.citrus.functions.FunctionRegistry;
import com.consol.citrus.log.LogModifier;
import com.consol.citrus.report.MessageListeners;
import com.consol.citrus.report.TestActionListeners;
import com.consol.citrus.report.TestListeners;
import com.consol.citrus.report.TestReporters;
import com.consol.citrus.report.TestSuiteListeners;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.util.TypeConverter;
import com.consol.citrus.validation.MessageValidatorRegistry;
import com.consol.citrus.validation.matcher.ValidationMatcherRegistry;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class CitrusSpringContext
extends CitrusContext {
    private final ApplicationContext applicationContext;

    protected CitrusSpringContext(Builder builder) {
        super((CitrusContext.Builder)builder);
        this.applicationContext = builder.applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void close() {
        if (this.applicationContext instanceof ConfigurableApplicationContext && ((ConfigurableApplicationContext)this.applicationContext).isActive()) {
            ((ConfigurableApplicationContext)this.applicationContext).close();
        }
    }

    public static CitrusSpringContext create() {
        return CitrusSpringContext.create((ApplicationContext)new AnnotationConfigApplicationContext(new Class[]{CitrusSpringConfig.class}));
    }

    public static CitrusSpringContext create(Class<? extends CitrusSpringConfig> configClass) {
        return CitrusSpringContext.create((ApplicationContext)new AnnotationConfigApplicationContext(new Class[]{configClass}));
    }

    public static CitrusSpringContext create(ApplicationContext applicationContext) {
        return new Builder().withApplicationContext(applicationContext).build();
    }

    public static final class Builder
    extends CitrusContext.Builder {
        private ApplicationContext applicationContext;

        public Builder withApplicationContext(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
            this.findBean(FunctionRegistry.class).ifPresent(arg_0 -> ((Builder)this).functionRegistry(arg_0));
            this.findBean(ValidationMatcherRegistry.class).ifPresent(arg_0 -> ((Builder)this).validationMatcherRegistry(arg_0));
            this.findBean(MessageValidatorRegistry.class).ifPresent(arg_0 -> ((Builder)this).messageValidatorRegistry(arg_0));
            this.findBean(MessageListeners.class).ifPresent(arg_0 -> ((Builder)this).messageListeners(arg_0));
            this.findBean(TestListeners.class).ifPresent(arg_0 -> ((Builder)this).testListeners(arg_0));
            this.findBean(TestActionListeners.class).ifPresent(arg_0 -> ((Builder)this).testActionListeners(arg_0));
            this.findBean(TestReporters.class).ifPresent(arg_0 -> ((Builder)this).testReporters(arg_0));
            this.findBean(TestSuiteListeners.class).ifPresent(arg_0 -> ((Builder)this).testSuiteListeners(arg_0));
            this.findBean(TestContextFactoryBean.class).ifPresent(arg_0 -> ((Builder)this).testContextFactory(arg_0));
            this.findBean(ReferenceResolver.class).ifPresent(arg_0 -> ((Builder)this).referenceResolver(arg_0));
            this.findBean(TypeConverter.class).ifPresent(arg_0 -> ((Builder)this).typeConverter(arg_0));
            this.findBean(LogModifier.class).ifPresent(arg_0 -> ((Builder)this).logModifier(arg_0));
            this.beforeSuite(new ArrayList(applicationContext.getBeansOfType(BeforeSuite.class).values()));
            this.afterSuite(new ArrayList(applicationContext.getBeansOfType(AfterSuite.class).values()));
            return this;
        }

        private <T> Optional<T> findBean(Class<T> beanType) {
            try {
                return Optional.of(this.applicationContext.getBean(beanType));
            }
            catch (NoSuchBeanDefinitionException e) {
                return Optional.empty();
            }
        }

        public CitrusSpringContext build() {
            return new CitrusSpringContext(this);
        }
    }
}

