/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.common;

import com.consol.citrus.CitrusSpringContext;
import com.consol.citrus.DefaultTestCaseRunner;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestCase;
import com.consol.citrus.common.BeanDefinitionParserConfiguration;
import com.consol.citrus.common.DefaultTestLoader;
import com.consol.citrus.common.SpringXmlTestLoaderConfiguration;
import com.consol.citrus.common.TestSourceAware;
import com.consol.citrus.config.CitrusNamespaceParserRegistry;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.StringUtils;

public class SpringXmlTestLoader
extends DefaultTestLoader
implements TestSourceAware {
    private String source;

    protected void doLoad() {
        ApplicationContext ctx = this.loadApplicationContext();
        try {
            this.testCase = (TestCase)ctx.getBean(this.testName, TestCase.class);
            if (this.runner instanceof DefaultTestCaseRunner) {
                ((DefaultTestCaseRunner)this.runner).setTestCase(this.testCase);
            }
            this.configurer.forEach(handler -> handler.accept(this.testCase));
            this.citrus.run((TestAction)this.testCase, this.context);
            this.handler.forEach(handler -> handler.accept(this.testCase));
        }
        catch (NoSuchBeanDefinitionException e) {
            throw this.citrusContext.getTestContextFactory().getObject().handleError(this.testName, this.packageName, "Failed to load Spring XML test with name '" + this.testName + "'", (Exception)((Object)e));
        }
    }

    private ApplicationContext loadApplicationContext() {
        try {
            this.configureCustomParsers();
            return new ClassPathXmlApplicationContext(new String[]{this.getSource(), "com/consol/citrus/spring/annotation-config-ctx.xml"}, true, this.getParentApplicationContext());
        }
        catch (Exception e) {
            throw this.citrusContext.getTestContextFactory().getObject().handleError(this.testName, this.packageName, "Failed to load test case", e);
        }
    }

    private void configureCustomParsers() {
        SpringXmlTestLoaderConfiguration loaderConfiguration = this.testClass.getAnnotation(SpringXmlTestLoaderConfiguration.class);
        if (loaderConfiguration != null) {
            for (BeanDefinitionParserConfiguration beanDefinitionParserConfiguration : loaderConfiguration.parserConfigurations()) {
                Class<? extends BeanDefinitionParser> parserClass = beanDefinitionParserConfiguration.parser();
                try {
                    if (parserClass == null) continue;
                    BeanDefinitionParser parserOverride = parserClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    CitrusNamespaceParserRegistry.registerParser(beanDefinitionParserConfiguration.name(), parserOverride);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new CitrusRuntimeException(String.format("Could not install custom BeanDefinitionParser '%s'", parserClass), (Throwable)e);
                }
            }
        }
    }

    private ApplicationContext getParentApplicationContext() {
        if (this.citrusContext instanceof CitrusSpringContext) {
            return ((CitrusSpringContext)this.citrusContext).getApplicationContext();
        }
        return null;
    }

    public String getSource() {
        if (StringUtils.hasText((String)this.source)) {
            return this.source;
        }
        return this.packageName.replace('.', File.separatorChar) + File.separator + this.testName + ".xml";
    }

    public void setSource(String source) {
        this.source = source;
    }

    public SpringXmlTestLoader source(String source) {
        this.setSource(source);
        return this;
    }
}

