/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.actions.PurgeEndpointAction;
import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.config.xml.AbstractTestActionFactoryBean;
import com.consol.citrus.config.xml.DescriptionElementParser;
import com.consol.citrus.config.xml.MessageSelectorParser;
import com.consol.citrus.context.SpringBeanReferenceResolver;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.spi.ReferenceResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class PurgeEndpointActionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(PurgeEndpointActionFactoryBean.class);
        DescriptionElementParser.doParse(element, beanDefinition);
        MessageSelectorParser.doParse(element, beanDefinition);
        BeanDefinitionParserUtils.setPropertyValue(beanDefinition, element.getAttribute("receive-timeout"), "receiveTimeout");
        ArrayList<String> endpointNames = new ArrayList<String>();
        ManagedList endpointRefs = new ManagedList();
        List endpointElements = DomUtils.getChildElementsByTagName((Element)element, (String)"endpoint");
        for (Object endpointElement : endpointElements) {
            Element endpoint = (Element)endpointElement;
            String endpointName = endpoint.getAttribute("name");
            String endpointRef = endpoint.getAttribute("ref");
            if (StringUtils.hasText((String)endpointName)) {
                endpointNames.add(endpointName);
                continue;
            }
            if (StringUtils.hasText((String)endpointRef)) {
                endpointRefs.add((Object)BeanDefinitionBuilder.childBeanDefinition((String)endpointRef).getBeanDefinition());
                continue;
            }
            throw new BeanCreationException("Element 'endpoint' must set one of the attributes 'name' or 'ref'");
        }
        beanDefinition.addPropertyValue("endpointNames", endpointNames);
        beanDefinition.addPropertyValue("endpoints", (Object)endpointRefs);
        return beanDefinition.getBeanDefinition();
    }

    public static class PurgeEndpointActionFactoryBean
    extends AbstractTestActionFactoryBean<PurgeEndpointAction, PurgeEndpointAction.Builder>
    implements ApplicationContextAware {
        private final PurgeEndpointAction.Builder builder = new PurgeEndpointAction.Builder();

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.builder.referenceResolver((ReferenceResolver)new SpringBeanReferenceResolver(applicationContext));
        }

        public void setEndpointNames(List<String> endpointNames) {
            this.builder.endpointNames(endpointNames);
        }

        public void setEndpoints(List<Endpoint> endpoints) {
            this.builder.endpoints(endpoints);
        }

        public void setMessageSelectorMap(Map<String, Object> messageSelectorMap) {
            this.builder.selector(messageSelectorMap);
        }

        public void setMessageSelector(String messageSelector) {
            this.builder.selector(messageSelector);
        }

        public void setReceiveTimeout(long receiveTimeout) {
            this.builder.timeout(receiveTimeout);
        }

        public void setSleepTime(long sleepTime) {
            this.builder.sleep(sleepTime);
        }

        public PurgeEndpointAction getObject() throws Exception {
            return this.builder.build();
        }

        public Class<?> getObjectType() {
            return PurgeEndpointAction.class;
        }

        @Override
        public PurgeEndpointAction.Builder getBuilder() {
            return this.builder;
        }
    }
}

