/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.context;

import com.consol.citrus.context.resolver.TypeAliasResolver;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.SimpleReferenceResolver;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringBeanReferenceResolver
implements ReferenceResolver,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringBeanReferenceResolver.class);
    private ApplicationContext applicationContext;
    private ReferenceResolver fallback = new SimpleReferenceResolver();
    private final Map<String, TypeAliasResolver<?, ?>> typeAliasResolvers = new HashMap();

    public SpringBeanReferenceResolver() {
    }

    public SpringBeanReferenceResolver(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public <T> T resolve(Class<T> requiredType) {
        try {
            return (T)this.applicationContext.getBean(requiredType);
        }
        catch (NoSuchBeanDefinitionException e) {
            if (this.fallback.isResolvable(requiredType)) {
                return (T)this.fallback.resolve(requiredType);
            }
            return this.resolveAlias(requiredType, this::resolve).orElseThrow(() -> new CitrusRuntimeException(String.format("Unable to find bean reference for type '%s'", requiredType), (Throwable)e));
        }
    }

    public <T> T resolve(String name, Class<T> type) {
        try {
            return (T)this.applicationContext.getBean(name, type);
        }
        catch (NoSuchBeanDefinitionException e) {
            if (this.fallback.isResolvable(name, type)) {
                return (T)this.fallback.resolve(name, type);
            }
            return this.resolveAlias(type, clazz -> this.resolve(name, (Class)clazz)).orElseThrow(() -> new CitrusRuntimeException(String.format("Unable to find bean reference for name '%s'", name), (Throwable)e));
        }
    }

    public Object resolve(String name) {
        try {
            return this.applicationContext.getBean(name);
        }
        catch (NoSuchBeanDefinitionException e) {
            if (this.fallback.isResolvable(name)) {
                return this.fallback.resolve(name);
            }
            throw new CitrusRuntimeException(String.format("Unable to find bean reference for name '%s'", name), (Throwable)e);
        }
    }

    public <T> Map<String, T> resolveAll(Class<T> requiredType) {
        Map beans = this.applicationContext.getBeansOfType(requiredType);
        if (beans.isEmpty()) {
            if (this.fallback.isResolvable(requiredType)) {
                return this.fallback.resolveAll(requiredType);
            }
            return this.resolveAllAlias(requiredType, this::resolveAll).orElseGet(HashMap::new);
        }
        return beans;
    }

    public boolean isResolvable(String name) {
        return this.applicationContext.containsBean(name) || this.fallback.isResolvable(name);
    }

    public boolean isResolvable(Class<?> type) {
        boolean canResolve;
        boolean bl = canResolve = this.applicationContext.getBeanNamesForType(type).length > 0 || this.fallback.isResolvable(type);
        if (!canResolve) {
            Optional<TypeAliasResolver> aliasResolver = this.typeAliasResolvers.values().stream().filter(resolver -> resolver.isAliasFor(type)).findFirst();
            if (aliasResolver.isEmpty()) {
                aliasResolver = TypeAliasResolver.lookup().values().stream().filter(resolver -> resolver.isAliasFor(type)).findFirst();
            }
            if (aliasResolver.isPresent()) {
                canResolve = this.applicationContext.getBeanNamesForType(aliasResolver.get().getAliasType()).length > 0 || this.fallback.isResolvable(aliasResolver.get().getAliasType());
            }
        }
        return canResolve;
    }

    public boolean isResolvable(String name, Class<?> type) {
        boolean canResolve;
        boolean bl = canResolve = Arrays.asList(this.applicationContext.getBeanNamesForType(type)).contains(name) || this.fallback.isResolvable(name, type);
        if (!canResolve) {
            Optional<TypeAliasResolver> aliasResolver;
            if (this.typeAliasResolvers.containsKey(name) && this.typeAliasResolvers.get(name).isAliasFor(type)) {
                boolean bl2 = canResolve = Arrays.asList(this.applicationContext.getBeanNamesForType(this.typeAliasResolvers.get(name).getAliasType())).contains(name) || this.fallback.isResolvable(name, this.typeAliasResolvers.get(name).getAliasType());
            }
            if ((aliasResolver = this.typeAliasResolvers.values().stream().filter(resolver -> resolver.isAliasFor(type)).findFirst()).isEmpty()) {
                aliasResolver = TypeAliasResolver.lookup().values().stream().filter(resolver -> resolver.isAliasFor(type)).findFirst();
            }
            if (aliasResolver.isPresent()) {
                canResolve = Arrays.asList(this.applicationContext.getBeanNamesForType(aliasResolver.get().getAliasType())).contains(name) || this.fallback.isResolvable(name, aliasResolver.get().getAliasType());
            }
        }
        return canResolve;
    }

    public SpringBeanReferenceResolver withFallback(ReferenceResolver fallback) {
        this.fallback = fallback;
        return this;
    }

    public void bind(String name, Object value) {
        this.fallback.bind(name, value);
    }

    private <T> Optional<T> resolveAlias(Class<T> source, Function<Class<?>, ?> supplier) {
        Optional<TypeAliasResolver> aliasResolver = this.typeAliasResolvers.values().stream().filter(resolver -> resolver.isAliasFor(source)).findFirst();
        if (aliasResolver.isEmpty()) {
            aliasResolver = TypeAliasResolver.lookup().values().stream().filter(resolver -> resolver.isAliasFor(source)).findFirst();
        }
        if (aliasResolver.isPresent()) {
            TypeAliasResolver resolver2 = aliasResolver.get();
            try {
                return Optional.of(resolver2.adapt(supplier.apply(resolver2.getAliasType())));
            }
            catch (Exception e) {
                log.warn(String.format("Unable to resolve alias type %s for required source %s", resolver2.getAliasType(), source));
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private <T> Optional<Map<String, T>> resolveAllAlias(Class<T> source, Function<Class<?>, Map<String, ?>> supplier) {
        Optional<TypeAliasResolver> aliasResolver = this.typeAliasResolvers.values().stream().filter(resolver -> resolver.isAliasFor(source)).findFirst();
        if (aliasResolver.isEmpty()) {
            aliasResolver = TypeAliasResolver.lookup().values().stream().filter(resolver -> resolver.isAliasFor(source)).findFirst();
        }
        if (aliasResolver.isPresent()) {
            TypeAliasResolver resolver2 = aliasResolver.get();
            try {
                return Optional.of(supplier.apply(resolver2.getAliasType()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> resolver2.adapt(v.getValue()))));
            }
            catch (Exception e) {
                log.warn(String.format("Unable to resolve alias type %s for required source %s", resolver2.getAliasType(), source));
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public void registerTypeAliasResolver(String name, TypeAliasResolver<?, ?> aliasResolver) {
        this.typeAliasResolvers.put(name, aliasResolver);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setFallback(ReferenceResolver fallback) {
        this.fallback = fallback;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

