/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.context;

import com.consol.citrus.container.AfterTest;
import com.consol.citrus.container.BeforeTest;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.context.TestContextFactory;
import com.consol.citrus.endpoint.EndpointFactory;
import com.consol.citrus.functions.FunctionRegistry;
import com.consol.citrus.log.LogModifier;
import com.consol.citrus.message.MessageProcessors;
import com.consol.citrus.report.MessageListeners;
import com.consol.citrus.report.TestActionListeners;
import com.consol.citrus.report.TestListeners;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.util.TypeConverter;
import com.consol.citrus.validation.MessageValidatorRegistry;
import com.consol.citrus.validation.matcher.ValidationMatcherRegistry;
import com.consol.citrus.variable.GlobalVariables;
import com.consol.citrus.variable.SegmentVariableExtractorRegistry;
import com.consol.citrus.xml.namespace.NamespaceContextBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

public class TestContextFactoryBean
extends TestContextFactory
implements FactoryBean<TestContext>,
InitializingBean,
ApplicationContextAware {
    @Autowired
    private FunctionRegistry functionRegistry;
    @Autowired
    private ValidationMatcherRegistry validationMatcherRegistry;
    @Autowired(required=false)
    private GlobalVariables globalVariables;
    @Autowired
    private MessageValidatorRegistry messageValidatorRegistry;
    @Autowired
    private TestListeners testListeners;
    @Autowired
    private TestActionListeners testActionListeners;
    @Autowired(required=false)
    private List<BeforeTest> beforeTest = new ArrayList<BeforeTest>();
    @Autowired(required=false)
    private List<AfterTest> afterTest = new ArrayList<AfterTest>();
    @Autowired
    private MessageListeners messageListeners;
    @Autowired
    private EndpointFactory endpointFactory;
    @Autowired
    private ReferenceResolver referenceResolver;
    @Autowired
    private TypeConverter typeConverter;
    @Autowired
    private LogModifier logModifier;
    @Autowired
    private MessageProcessors messageProcessors;
    @Autowired(required=false)
    private NamespaceContextBuilder namespaceContextBuilder;
    @Autowired
    private SegmentVariableExtractorRegistry segmentVariableExtractorRegistry;
    private ApplicationContext applicationContext;
    private final TestContextFactory delegate;

    public TestContextFactoryBean() {
        this(TestContextFactory.newInstance());
    }

    public TestContextFactoryBean(TestContextFactory factory) {
        this.delegate = factory;
    }

    public static TestContextFactory newInstance(ApplicationContext applicationContext) {
        TestContextFactory factory = TestContextFactory.newInstance();
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(FunctionRegistry.class))) {
            factory.setFunctionRegistry((FunctionRegistry)applicationContext.getBean(FunctionRegistry.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(ValidationMatcherRegistry.class))) {
            factory.setValidationMatcherRegistry((ValidationMatcherRegistry)applicationContext.getBean(ValidationMatcherRegistry.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(GlobalVariables.class))) {
            factory.setGlobalVariables((GlobalVariables)applicationContext.getBean(GlobalVariables.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(MessageValidatorRegistry.class))) {
            factory.setMessageValidatorRegistry((MessageValidatorRegistry)applicationContext.getBean(MessageValidatorRegistry.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(TestListeners.class))) {
            factory.setTestListeners((TestListeners)applicationContext.getBean(TestListeners.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(MessageListeners.class))) {
            factory.setMessageListeners((MessageListeners)applicationContext.getBean(MessageListeners.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(MessageProcessors.class))) {
            factory.setMessageProcessors((MessageProcessors)applicationContext.getBean(MessageProcessors.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(EndpointFactory.class))) {
            factory.setEndpointFactory((EndpointFactory)applicationContext.getBean(EndpointFactory.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(ReferenceResolver.class))) {
            factory.setReferenceResolver((ReferenceResolver)applicationContext.getBean(ReferenceResolver.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(TypeConverter.class))) {
            factory.setTypeConverter((TypeConverter)applicationContext.getBean(TypeConverter.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(LogModifier.class))) {
            factory.setLogModifier((LogModifier)applicationContext.getBean(LogModifier.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(NamespaceContextBuilder.class))) {
            factory.setNamespaceContextBuilder((NamespaceContextBuilder)applicationContext.getBean(NamespaceContextBuilder.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(SegmentVariableExtractorRegistry.class))) {
            factory.setSegmentVariableExtractorRegistry((SegmentVariableExtractorRegistry)applicationContext.getBean(SegmentVariableExtractorRegistry.class));
        }
        return factory;
    }

    public Class<TestContext> getObjectType() {
        return TestContext.class;
    }

    public TestContext getObject() {
        return this.delegate.getObject();
    }

    public boolean isSingleton() {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.functionRegistry != null) {
            this.delegate.setFunctionRegistry(this.functionRegistry);
        }
        if (this.validationMatcherRegistry != null) {
            this.delegate.setValidationMatcherRegistry(this.validationMatcherRegistry);
        }
        if (this.globalVariables != null) {
            this.delegate.setGlobalVariables(this.globalVariables);
        }
        if (this.messageValidatorRegistry != null) {
            this.delegate.setMessageValidatorRegistry(this.messageValidatorRegistry);
        }
        if (this.testListeners != null) {
            this.delegate.setTestListeners(this.testListeners);
        }
        if (this.testActionListeners != null) {
            this.delegate.setTestActionListeners(this.testActionListeners);
        }
        if (this.beforeTest != null) {
            this.delegate.setBeforeTest(this.beforeTest);
        }
        if (this.afterTest != null) {
            this.delegate.setAfterTest(this.afterTest);
        }
        if (this.messageListeners != null) {
            this.delegate.setMessageListeners(this.messageListeners);
        }
        if (this.messageProcessors != null) {
            this.delegate.setMessageProcessors(this.messageProcessors);
        }
        if (this.endpointFactory != null) {
            this.delegate.setEndpointFactory(this.endpointFactory);
        }
        if (this.referenceResolver != null) {
            this.delegate.setReferenceResolver(this.referenceResolver);
        }
        if (this.typeConverter != null) {
            this.delegate.setTypeConverter(this.typeConverter);
        }
        if (this.logModifier != null) {
            this.delegate.setLogModifier(this.logModifier);
        }
        if (this.namespaceContextBuilder != null) {
            this.delegate.setNamespaceContextBuilder(this.namespaceContextBuilder);
        }
        if (this.segmentVariableExtractorRegistry != null) {
            this.delegate.setSegmentVariableExtractorRegistry(this.segmentVariableExtractorRegistry);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public FunctionRegistry getFunctionRegistry() {
        return this.delegate.getFunctionRegistry();
    }

    public ValidationMatcherRegistry getValidationMatcherRegistry() {
        return this.delegate.getValidationMatcherRegistry();
    }

    public GlobalVariables getGlobalVariables() {
        return this.delegate.getGlobalVariables();
    }

    public MessageValidatorRegistry getMessageValidatorRegistry() {
        return this.delegate.getMessageValidatorRegistry();
    }

    public TestListeners getTestListeners() {
        return this.delegate.getTestListeners();
    }

    public TestActionListeners getTestActionListeners() {
        return this.delegate.getTestActionListeners();
    }

    public List<BeforeTest> getBeforeTest() {
        return this.delegate.getBeforeTest();
    }

    public List<AfterTest> getAfterTest() {
        return this.delegate.getAfterTest();
    }

    public MessageListeners getMessageListeners() {
        return this.delegate.getMessageListeners();
    }

    public MessageProcessors getMessageProcessors() {
        return this.delegate.getMessageProcessors();
    }

    public EndpointFactory getEndpointFactory() {
        return this.delegate.getEndpointFactory();
    }

    public ReferenceResolver getReferenceResolver() {
        return this.delegate.getReferenceResolver();
    }

    public TypeConverter getTypeConverter() {
        return this.delegate.getTypeConverter();
    }

    public LogModifier getLogModifier() {
        return this.delegate.getLogModifier();
    }

    public NamespaceContextBuilder getNamespaceContextBuilder() {
        return this.delegate.getNamespaceContextBuilder();
    }

    public SegmentVariableExtractorRegistry getSegmentVariableExtractorRegistry() {
        return this.delegate.getSegmentVariableExtractorRegistry();
    }
}

