/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.actions.AbstractDatabaseConnectingTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.transaction.support.TransactionTemplate;

public class ExecuteSQLAction
extends AbstractDatabaseConnectingTestAction {
    private final boolean ignoreErrors;

    private ExecuteSQLAction(Builder builder) {
        super("sql", builder);
        this.ignoreErrors = builder.ignoreErrors;
    }

    @Override
    public void doExecute(TestContext context) {
        List<String> statementsToUse = this.statements.isEmpty() ? this.createStatementsFromFileResource(context) : this.statements;
        if (this.getTransactionManager() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Using transaction manager: " + this.getTransactionManager().getClass().getName());
            }
            TransactionTemplate transactionTemplate = new TransactionTemplate(this.getTransactionManager());
            transactionTemplate.setTimeout(Integer.parseInt(context.replaceDynamicContentInString(this.getTransactionTimeout())));
            transactionTemplate.setIsolationLevelName(context.replaceDynamicContentInString(this.getTransactionIsolationLevel()));
            transactionTemplate.execute(status -> {
                this.executeStatements(statementsToUse, context);
                return null;
            });
        } else {
            this.executeStatements(statementsToUse, context);
        }
    }

    protected void executeStatements(List<String> statements, TestContext context) {
        for (String stmt : statements) {
            try {
                String toExecute = stmt.trim().endsWith(";") ? context.replaceDynamicContentInString(stmt.trim().substring(0, stmt.trim().length() - 1)) : context.replaceDynamicContentInString(stmt.trim());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Executing SQL statement: " + toExecute);
                }
                this.getJdbcTemplate().execute(toExecute);
                this.log.info("SQL statement execution successful");
            }
            catch (Exception e) {
                if (this.ignoreErrors) {
                    this.log.error("Ignoring error while executing SQL statement: " + e.getLocalizedMessage());
                    continue;
                }
                throw new CitrusRuntimeException((Throwable)e);
            }
        }
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public static final class Builder
    extends AbstractDatabaseConnectingTestAction.Builder<ExecuteSQLAction, Builder> {
        private boolean ignoreErrors = false;

        public static Builder sql(DataSource dataSource) {
            Builder builder = new Builder();
            builder.dataSource(dataSource);
            return builder;
        }

        public Builder ignoreErrors(boolean ignoreErrors) {
            this.ignoreErrors = ignoreErrors;
            return this;
        }

        public ExecuteSQLAction build() {
            return new ExecuteSQLAction(this);
        }
    }
}

