/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.sql.xml;

import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.actions.AbstractDatabaseConnectingTestAction;
import com.consol.citrus.actions.ExecuteSQLAction;
import com.consol.citrus.actions.ExecuteSQLQueryAction;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.StringUtils;

@XmlRootElement(name="sql")
public class Sql
implements TestActionBuilder<AbstractDatabaseConnectingTestAction>,
ReferenceResolverAware {
    private AbstractDatabaseConnectingTestAction.Builder<?, ?> builder = new ExecuteSQLAction.Builder();
    private String dataSource;
    private String transactionManager;
    private ReferenceResolver referenceResolver;
    @XmlElement(name="validate")
    protected List<Validate> validates;
    @XmlElement(name="extract")
    protected List<Extract> extracts;

    @XmlElement
    public Sql setDescription(String value) {
        this.builder.description(value);
        return this;
    }

    @XmlAttribute(name="datasource", required=true)
    public Sql setDataSource(String dataSource) {
        this.dataSource = dataSource;
        this.builder.name(String.format("sql:%s", dataSource));
        return this;
    }

    @XmlElement(required=true)
    public Sql setStatements(Statements statements) {
        statements.getStatements().forEach(this.builder::statement);
        if (statements.file != null) {
            this.builder.sqlResource(statements.file);
        }
        return this;
    }

    @XmlElement
    public Sql setTransaction(Transaction transaction) {
        if (transaction.manager != null) {
            this.transactionManager = transaction.manager;
        }
        if (transaction.isolationLevel != null) {
            this.builder.transactionIsolationLevel(transaction.isolationLevel);
        }
        if (transaction.timeout != null) {
            this.builder.transactionTimeout(transaction.timeout);
        }
        return this;
    }

    @XmlAttribute(name="ignore-errors")
    public Sql setIgnoreErrors(boolean value) {
        if (this.builder instanceof ExecuteSQLAction.Builder) {
            ((ExecuteSQLAction.Builder)this.builder).ignoreErrors(value);
        }
        return this;
    }

    public List<Validate> getValidates() {
        if (this.validates == null) {
            this.validates = new ArrayList<Validate>();
        }
        return this.validates;
    }

    public List<Extract> getExtracts() {
        if (this.extracts == null) {
            this.extracts = new ArrayList<Extract>();
        }
        return this.extracts;
    }

    public AbstractDatabaseConnectingTestAction build() {
        if (this.referenceResolver != null) {
            this.builder.dataSource((DataSource)this.referenceResolver.resolve(this.dataSource, DataSource.class));
            if (this.transactionManager != null) {
                this.builder.transactionManager((PlatformTransactionManager)this.referenceResolver.resolve(this.transactionManager, PlatformTransactionManager.class));
            }
        }
        for (Validate validate : this.getValidates()) {
            Validate.Script script;
            if (validate.column != null) {
                if (validate.value != null) {
                    this.asSqlQueryBuilder().validate(validate.column, validate.value);
                }
                if (validate.getValues() != null) {
                    this.asSqlQueryBuilder().validate(validate.column, (String[])validate.getValues().getValues().toArray(String[]::new));
                }
            }
            if ((script = validate.script) == null) continue;
            String type = script.getType();
            String filePath = script.getFile();
            if (StringUtils.hasText((String)filePath)) {
                if (script.getCharset() != null) {
                    this.asSqlQueryBuilder().validateScriptResource(filePath, type, Charset.forName(script.getCharset()));
                    continue;
                }
                this.asSqlQueryBuilder().validateScriptResource(filePath, type, StandardCharsets.UTF_8);
                continue;
            }
            if (script.getValue() == null) continue;
            this.asSqlQueryBuilder().validateScript(script.getValue().trim(), type);
        }
        for (Extract extract : this.getExtracts()) {
            this.asSqlQueryBuilder().extract(extract.column, extract.variable);
        }
        return (AbstractDatabaseConnectingTestAction)this.builder.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    private ExecuteSQLQueryAction.Builder asSqlQueryBuilder() {
        if (this.builder instanceof ExecuteSQLQueryAction.Builder) {
            return (ExecuteSQLQueryAction.Builder)this.builder;
        }
        ExecuteSQLQueryAction.Builder sqlQueryBuilder = new ExecuteSQLQueryAction.Builder();
        AbstractDatabaseConnectingTestAction base = (AbstractDatabaseConnectingTestAction)this.builder.build();
        sqlQueryBuilder.description(base.getDescription());
        sqlQueryBuilder.dataSource(base.getDataSource());
        sqlQueryBuilder.jdbcTemplate(base.getJdbcTemplate());
        sqlQueryBuilder.sqlResource(base.getSqlResourcePath());
        sqlQueryBuilder.statements(base.getStatements());
        sqlQueryBuilder.transactionManager(base.getTransactionManager());
        sqlQueryBuilder.transactionTimeout(base.getTransactionTimeout());
        sqlQueryBuilder.transactionIsolationLevel(base.getTransactionIsolationLevel());
        sqlQueryBuilder.actor(base.getActor());
        this.builder = sqlQueryBuilder;
        return sqlQueryBuilder;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"values", "script"})
    public static class Validate {
        @XmlElement
        protected Values values;
        @XmlAttribute(name="column")
        protected String column;
        @XmlAttribute(name="value")
        protected String value;
        @XmlElement
        protected Script script;

        public Values getValues() {
            return this.values;
        }

        public void setValues(Values value) {
            this.values = value;
        }

        public String getColumn() {
            return this.column;
        }

        public void setColumn(String value) {
            this.column = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"value"})
        public static class Script {
            @XmlValue
            protected String value;
            @XmlAttribute(name="type", required=true)
            protected String type;
            @XmlAttribute(name="file")
            protected String file;
            @XmlAttribute(name="charset")
            protected String charset;

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public String getType() {
                return this.type;
            }

            public void setType(String value) {
                this.type = value;
            }

            public String getFile() {
                return this.file;
            }

            public void setFile(String value) {
                this.file = value;
            }

            public void setCharset(String charset) {
                this.charset = charset;
            }

            public String getCharset() {
                return this.charset;
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"values"})
        public static class Values {
            @XmlElement(name="value", required=true)
            protected List<String> values;

            public List<String> getValues() {
                if (this.values == null) {
                    this.values = new ArrayList<String>();
                }
                return this.values;
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="")
    public static class Extract {
        @XmlAttribute(name="column", required=true)
        protected String column;
        @XmlAttribute(name="variable", required=true)
        protected String variable;

        public String getColumn() {
            return this.column;
        }

        public void setColumn(String value) {
            this.column = value;
        }

        public String getVariable() {
            return this.variable;
        }

        public void setVariable(String value) {
            this.variable = value;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="")
    public static class Transaction {
        @XmlAttribute(name="manager")
        protected String manager;
        @XmlAttribute(name="timeout")
        protected String timeout;
        @XmlAttribute(name="isolation-level")
        protected String isolationLevel;

        public String getManager() {
            return this.manager;
        }

        public void setManager(String manager) {
            this.manager = manager;
        }

        public String getTimeout() {
            return this.timeout;
        }

        public void setTimeout(String timeout) {
            this.timeout = timeout;
        }

        public String getIsolationLevel() {
            return this.isolationLevel;
        }

        public void setIsolationLevel(String isolationLevel) {
            this.isolationLevel = isolationLevel;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"statements"})
    public static class Statements {
        @XmlElement(name="statement")
        private List<String> statements;
        @XmlAttribute(name="file")
        protected String file;

        public String getFile() {
            return this.file;
        }

        public void setFile(String value) {
            this.file = value;
        }

        public List<String> getStatements() {
            if (this.statements == null) {
                this.statements = new ArrayList<String>();
            }
            return this.statements;
        }
    }
}

