/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ssh.message;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageConverter;
import com.consol.citrus.ssh.client.SshEndpointConfiguration;
import com.consol.citrus.ssh.model.SshMessage;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.springframework.xml.transform.StringResult;

public class SshMessageConverter
implements MessageConverter<SshMessage, SshEndpointConfiguration> {
    public SshMessage convertOutbound(Message internalMessage, SshEndpointConfiguration endpointConfiguration, TestContext context) {
        Object payload = internalMessage.getPayload();
        SshMessage sshMessage = null;
        if (payload != null) {
            sshMessage = payload instanceof SshMessage ? (SshMessage)payload : (SshMessage)endpointConfiguration.getSshMarshaller().unmarshal((Source)internalMessage.getPayload(Source.class));
        }
        if (sshMessage == null) {
            throw new CitrusRuntimeException("Unable to create proper ssh message from payload: " + payload);
        }
        return sshMessage;
    }

    public void convertOutbound(SshMessage externalMessage, Message internalMessage, SshEndpointConfiguration endpointConfiguration, TestContext context) {
    }

    public Message convertInbound(SshMessage externalMessage, SshEndpointConfiguration endpointConfiguration, TestContext context) {
        StringResult payload = new StringResult();
        endpointConfiguration.getSshMarshaller().marshal(externalMessage, (Result)payload);
        return new DefaultMessage((Object)payload.toString());
    }
}

