/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ssh.server;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.PublicKey;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SinglePublicKeyAuthenticator
implements PublickeyAuthenticator {
    private static Logger log = LoggerFactory.getLogger(SinglePublicKeyAuthenticator.class);
    private PublicKey allowedKey;
    private String user;
    private BouncyCastleProvider provider = new BouncyCastleProvider();

    public SinglePublicKeyAuthenticator(String pUser, String pPublicKeyPath) {
        this.user = pUser;
        InputStream is = null;
        try {
            if (pPublicKeyPath.startsWith("classpath:")) {
                String resource = pPublicKeyPath.substring("classpath:".length());
                is = this.getClass().getClassLoader().getResourceAsStream(resource);
                if (is == null) {
                    throw new CitrusRuntimeException("No key resource found at classpath at " + resource);
                }
            } else {
                is = new FileInputStream(pPublicKeyPath);
            }
            this.allowedKey = this.readKey(is);
            if (this.allowedKey == null) {
                throw new CitrusRuntimeException("No public key found at " + pPublicKeyPath + ", although the file/resource exists. It is probably not in a PEM form or contains more than only a public key.");
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new CitrusRuntimeException("public key file does not exist at " + pPublicKeyPath, (Throwable)e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly((Closeable[])new Closeable[]{is});
                throw throwable;
            }
        }
        IoUtils.closeQuietly((Closeable[])new Closeable[]{is});
    }

    public boolean authenticate(String pUser, PublicKey pKey, ServerSession pSession) {
        return this.user != null && this.user.equals(pUser) && this.allowedKey.equals(pKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private PublicKey readKey(InputStream is) {
        block6: {
            block5: {
                isr = new InputStreamReader(is);
                r = new PEMParser((Reader)isr);
                o = r.readObject();
                if (!(o instanceof PEMKeyPair)) ** GOTO lbl16
                keyPair = (PEMKeyPair)o;
                if (keyPair.getPublicKeyInfo() == null || keyPair.getPublicKeyInfo().getEncoded().length <= 0) break block5;
                var6_8 = BouncyCastleProvider.getPublicKey((SubjectPublicKeyInfo)keyPair.getPublicKeyInfo());
                IoUtils.closeQuietly((Closeable[])new Closeable[]{isr, r});
                return var6_8;
            }
            try {
                break block6;
lbl16:
                // 1 sources

                if (!(o instanceof SubjectPublicKeyInfo)) break block6;
                var5_7 = BouncyCastleProvider.getPublicKey((SubjectPublicKeyInfo)((SubjectPublicKeyInfo)o));
            }
            catch (IOException e) {
                try {
                    SinglePublicKeyAuthenticator.log.warn("Failed to get key from PEM file", (Throwable)e);
                }
                catch (Throwable var7_9) {
                    IoUtils.closeQuietly((Closeable[])new Closeable[]{isr, r});
                    throw var7_9;
                }
                IoUtils.closeQuietly((Closeable[])new Closeable[]{isr, r});
            }
            IoUtils.closeQuietly((Closeable[])new Closeable[]{isr, r});
            return var5_7;
        }
        IoUtils.closeQuietly((Closeable[])new Closeable[]{isr, r});
        return null;
    }
}

