/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ssh;

import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.message.Message;
import com.consol.citrus.ssh.client.SshEndpointConfiguration;
import com.consol.citrus.ssh.model.SshRequest;
import com.consol.citrus.ssh.model.SshResponse;
import com.consol.citrus.util.FileUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.command.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshCommand
implements Command,
Runnable {
    private static Logger log = LoggerFactory.getLogger(SshCommand.class);
    private final EndpointAdapter endpointAdapter;
    private final SshEndpointConfiguration endpointConfiguration;
    private final String command;
    private InputStream stdin;
    private OutputStream stdout;
    private OutputStream stderr;
    private ExitCallback exitCallback;
    private String user;

    public SshCommand(String command, EndpointAdapter endpointAdapter, SshEndpointConfiguration endpointConfiguration) {
        this.endpointAdapter = endpointAdapter;
        this.command = command;
        this.endpointConfiguration = endpointConfiguration;
    }

    public void start(Environment env) throws IOException {
        this.user = (String)env.getEnv().get("USER");
        new Thread((Runnable)this, "CitrusSshCommand: " + this.command).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String input = FileUtils.readToString((InputStream)this.stdin);
            SshRequest sshRequest = new SshRequest(this.command, input);
            Message response = this.endpointAdapter.handleMessage(this.endpointConfiguration.getMessageConverter().convertInbound(sshRequest, this.endpointConfiguration, null).setHeader("user", (Object)this.user));
            SshResponse sshResponse = (SshResponse)this.endpointConfiguration.getMessageConverter().convertOutbound(response, this.endpointConfiguration, null);
            this.copyToStream(sshResponse.getStderr(), this.stderr);
            this.copyToStream(sshResponse.getStdout(), this.stdout);
            this.exitCallback.onExit(sshResponse.getExit());
        }
        catch (IOException exp) {
            try {
                this.exitCallback.onExit(1, exp.getMessage());
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly((Closeable[])new Closeable[]{this.stderr});
                IoUtils.closeQuietly((Closeable[])new Closeable[]{this.stdout});
                throw throwable;
            }
            IoUtils.closeQuietly((Closeable[])new Closeable[]{this.stderr});
            IoUtils.closeQuietly((Closeable[])new Closeable[]{this.stdout});
        }
        IoUtils.closeQuietly((Closeable[])new Closeable[]{this.stderr});
        IoUtils.closeQuietly((Closeable[])new Closeable[]{this.stdout});
    }

    public void destroy() {
        log.warn("Destroy has been called");
    }

    public void setInputStream(InputStream in) {
        this.stdin = in;
    }

    public void setOutputStream(OutputStream out) {
        this.stdout = out;
    }

    public void setErrorStream(OutputStream err) {
        this.stderr = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.exitCallback = callback;
    }

    private void copyToStream(String txt, OutputStream stream) throws IOException {
        if (txt != null) {
            stream.write(txt.getBytes());
        }
    }

    public String getCommand() {
        return this.command;
    }
}

