/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ssh.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.config.annotation.AbstractAnnotationConfigParser;
import com.consol.citrus.message.MessageCorrelator;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.ssh.client.SshClient;
import com.consol.citrus.ssh.client.SshClientBuilder;
import com.consol.citrus.ssh.config.annotation.SshClientConfig;
import com.consol.citrus.ssh.message.SshMessageConverter;
import org.springframework.util.StringUtils;

public class SshClientConfigParser
extends AbstractAnnotationConfigParser<SshClientConfig, SshClient> {
    public SshClientConfigParser(ReferenceResolver referenceResolver) {
        super(referenceResolver);
    }

    public SshClient parse(SshClientConfig annotation) {
        SshClientBuilder builder = new SshClientBuilder();
        if (StringUtils.hasText((String)annotation.host())) {
            builder.host(annotation.host());
        }
        builder.port(annotation.port());
        if (StringUtils.hasText((String)annotation.privateKeyPath())) {
            builder.privateKeyPath(annotation.privateKeyPath());
        }
        if (StringUtils.hasText((String)annotation.privateKeyPassword())) {
            builder.privateKeyPassword(annotation.privateKeyPassword());
        }
        builder.strictHostChecking(annotation.strictHostChecking());
        if (StringUtils.hasText((String)annotation.knownHosts())) {
            builder.knownHosts(annotation.knownHosts());
        }
        builder.commandTimeout(annotation.commandTimeout());
        builder.connectionTimeout(annotation.connectionTimeout());
        if (StringUtils.hasText((String)annotation.user())) {
            builder.user(annotation.user());
        }
        if (StringUtils.hasText((String)annotation.password())) {
            builder.password(annotation.password());
        }
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((SshMessageConverter)this.getReferenceResolver().resolve(annotation.messageConverter(), SshMessageConverter.class));
        }
        if (StringUtils.hasText((String)annotation.correlator())) {
            builder.correlator((MessageCorrelator)this.getReferenceResolver().resolve(annotation.correlator(), MessageCorrelator.class));
        }
        builder.pollingInterval(annotation.pollingInterval());
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)this.getReferenceResolver().resolve(annotation.actor(), TestActor.class));
        }
        return (SshClient)builder.initialize().build();
    }
}

