/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ssh.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.config.annotation.AbstractAnnotationConfigParser;
import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.ssh.config.annotation.SshServerConfig;
import com.consol.citrus.ssh.message.SshMessageConverter;
import com.consol.citrus.ssh.server.SshServer;
import com.consol.citrus.ssh.server.SshServerBuilder;
import org.springframework.util.StringUtils;

public class SshServerConfigParser
extends AbstractAnnotationConfigParser<SshServerConfig, SshServer> {
    public SshServerConfigParser(ReferenceResolver referenceResolver) {
        super(referenceResolver);
    }

    public SshServer parse(SshServerConfig annotation) {
        SshServerBuilder builder = new SshServerBuilder();
        builder.port(annotation.port());
        if (StringUtils.hasText((String)annotation.user())) {
            builder.user(annotation.user());
        }
        if (StringUtils.hasText((String)annotation.password())) {
            builder.password(annotation.password());
        }
        if (StringUtils.hasText((String)annotation.hostKeyPath())) {
            builder.hostKeyPath(annotation.hostKeyPath());
        }
        if (StringUtils.hasText((String)annotation.userHomePath())) {
            builder.userHomePath(annotation.userHomePath());
        }
        if (StringUtils.hasText((String)annotation.allowedKeyPath())) {
            builder.allowedKeyPath(annotation.allowedKeyPath());
        }
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((SshMessageConverter)this.getReferenceResolver().resolve(annotation.messageConverter(), SshMessageConverter.class));
        }
        builder.pollingInterval(annotation.pollingInterval());
        builder.debugLogging(annotation.debugLogging());
        if (StringUtils.hasText((String)annotation.endpointAdapter())) {
            builder.endpointAdapter((EndpointAdapter)this.getReferenceResolver().resolve(annotation.endpointAdapter(), EndpointAdapter.class));
        }
        builder.autoStart(annotation.autoStart());
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)this.getReferenceResolver().resolve(annotation.actor(), TestActor.class));
        }
        return (SshServer)builder.initialize().build();
    }
}

