/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ssh.server;

import com.consol.citrus.endpoint.AbstractPollableEndpointConfiguration;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.server.AbstractServer;
import com.consol.citrus.ssh.SshCommand;
import com.consol.citrus.ssh.client.SshEndpointConfiguration;
import com.consol.citrus.ssh.message.SshMessageConverter;
import com.consol.citrus.ssh.model.SshMarshaller;
import com.consol.citrus.ssh.server.SimplePasswordAuthenticator;
import com.consol.citrus.ssh.server.SinglePublicKeyAuthenticator;
import com.consol.citrus.util.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.keyprovider.ClassLoadableResourceKeyPairProvider;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.scp.common.AbstractScpTransferEventListenerAdapter;
import org.apache.sshd.scp.common.ScpTransferEventListener;
import org.apache.sshd.scp.server.ScpCommandFactory;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.sftp.server.AbstractSftpEventListenerAdapter;
import org.apache.sshd.sftp.server.SftpEventListener;
import org.apache.sshd.sftp.server.SftpSubsystemFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class SshServer
extends AbstractServer {
    private int port = 22;
    private String user;
    private String password;
    private String allowedKeyPath;
    private String hostKeyPath;
    private String userHomePath;
    private SshMessageConverter messageConverter = new SshMessageConverter();
    private org.apache.sshd.server.SshServer sshd;
    private final SshEndpointConfiguration endpointConfiguration;

    public SshServer() {
        this(new SshEndpointConfiguration());
    }

    public SshServer(SshEndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
    }

    protected void startup() {
        if (!StringUtils.hasText((String)this.user)) {
            throw new CitrusRuntimeException("No 'user' provided (mandatory for authentication)");
        }
        this.sshd = org.apache.sshd.server.SshServer.setUpDefaultServer();
        this.sshd.setPort(this.port);
        VirtualFileSystemFactory fileSystemFactory = new VirtualFileSystemFactory();
        Path userHomeDir = Optional.ofNullable(this.userHomePath).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toAbsolutePath).orElse(Paths.get(String.format("target/%s/home/%s", this.getName(), this.user), new String[0]).toAbsolutePath());
        if (!Files.exists(userHomeDir, new LinkOption[0])) {
            try {
                Files.createDirectories(userHomeDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to setup user home dir", (Throwable)e);
            }
        }
        fileSystemFactory.setUserHomeDir(this.user, userHomeDir);
        this.sshd.setFileSystemFactory((FileSystemFactory)fileSystemFactory);
        if (this.hostKeyPath != null) {
            Resource hostKey = FileUtils.getFileResource((String)this.hostKeyPath);
            if (hostKey instanceof ClassPathResource) {
                ClassLoadableResourceKeyPairProvider resourceKeyPairProvider = new ClassLoadableResourceKeyPairProvider(Collections.singletonList(((ClassPathResource)hostKey).getPath()));
                this.sshd.setKeyPairProvider((KeyPairProvider)resourceKeyPairProvider);
            } else {
                try {
                    FileKeyPairProvider fileKeyPairProvider = new FileKeyPairProvider(Collections.singletonList(hostKey.getFile().toPath()));
                    this.sshd.setKeyPairProvider((KeyPairProvider)fileKeyPairProvider);
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to read host key path", (Throwable)e);
                }
            }
        } else {
            ClassLoadableResourceKeyPairProvider resourceKeyPairProvider = new ClassLoadableResourceKeyPairProvider(Collections.singletonList("com/consol/citrus/ssh/citrus.pem"));
            this.sshd.setKeyPairProvider((KeyPairProvider)resourceKeyPairProvider);
        }
        List availableSignatureFactories = this.sshd.getSignatureFactoriesNames();
        availableSignatureFactories.add("ssh-dss");
        this.sshd.setSignatureFactoriesNames((Collection)availableSignatureFactories);
        boolean authFound = false;
        if (this.password != null) {
            this.sshd.setPasswordAuthenticator((PasswordAuthenticator)new SimplePasswordAuthenticator(this.user, this.password));
            authFound = true;
        }
        if (this.allowedKeyPath != null) {
            this.sshd.setPublickeyAuthenticator((PublickeyAuthenticator)new SinglePublicKeyAuthenticator(this.user, this.allowedKeyPath));
            authFound = true;
        }
        if (!authFound) {
            throw new CitrusRuntimeException("Neither 'password' nor 'allowed-key-path' is set. Please provide at least one");
        }
        ScpCommandFactory commandFactory = new ScpCommandFactory.Builder().withDelegate((session, command) -> new SshCommand(command, this.getEndpointAdapter(), this.endpointConfiguration)).build();
        commandFactory.addEventListener(this.getScpTransferEventListener());
        this.sshd.setCommandFactory((CommandFactory)commandFactory);
        ArrayList<SftpSubsystemFactory> subsystemFactories = new ArrayList<SftpSubsystemFactory>();
        SftpSubsystemFactory sftpSubsystemFactory = new SftpSubsystemFactory.Builder().build();
        sftpSubsystemFactory.addSftpEventListener(this.getSftpEventListener());
        subsystemFactories.add(sftpSubsystemFactory);
        this.sshd.setSubsystemFactories(subsystemFactories);
        try {
            this.sshd.start();
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to start SSH server - " + e.getMessage(), (Throwable)e);
        }
    }

    protected ScpTransferEventListener getScpTransferEventListener() {
        return new AbstractScpTransferEventListenerAdapter(){};
    }

    protected SftpEventListener getSftpEventListener() {
        return new AbstractSftpEventListenerAdapter(){};
    }

    protected void shutdown() {
        try {
            this.sshd.stop();
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to stop SSH server - " + e.getMessage(), (Throwable)e);
        }
    }

    public AbstractPollableEndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.endpointConfiguration.setPort(port);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
        this.endpointConfiguration.setUser(user);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.endpointConfiguration.setPassword(password);
    }

    public String getAllowedKeyPath() {
        return this.allowedKeyPath;
    }

    public void setAllowedKeyPath(String allowedKeyPath) {
        this.allowedKeyPath = allowedKeyPath;
    }

    public String getHostKeyPath() {
        return this.hostKeyPath;
    }

    public void setHostKeyPath(String hostKeyPath) {
        this.hostKeyPath = hostKeyPath;
    }

    public String getUserHomePath() {
        return this.userHomePath;
    }

    public void setUserHomePath(String userHomePath) {
        this.userHomePath = userHomePath;
    }

    public SshMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMarshaller(SshMarshaller marshaller) {
        this.endpointConfiguration.setSshMarshaller(marshaller);
    }

    public void setMessageConverter(SshMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
        this.endpointConfiguration.setMessageConverter(messageConverter);
    }
}

