/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ssh.server;

import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.server.AbstractServerBuilder;
import com.consol.citrus.ssh.message.SshMessageConverter;
import com.consol.citrus.ssh.model.SshMarshaller;
import com.consol.citrus.ssh.server.SshServer;

public class SshServerBuilder
extends AbstractServerBuilder<SshServer, SshServerBuilder> {
    private final SshServer endpoint = new SshServer();

    protected SshServer getEndpoint() {
        return this.endpoint;
    }

    public SshServerBuilder port(int port) {
        this.endpoint.setPort(port);
        return this;
    }

    public SshServerBuilder user(String user) {
        this.endpoint.setUser(user);
        return this;
    }

    public SshServerBuilder password(String password) {
        this.endpoint.setPassword(password);
        return this;
    }

    public SshServerBuilder hostKeyPath(String hostKeyPath) {
        this.endpoint.setHostKeyPath(hostKeyPath);
        return this;
    }

    public SshServerBuilder userHomePath(String userHomePath) {
        this.endpoint.setUserHomePath(userHomePath);
        return this;
    }

    public SshServerBuilder allowedKeyPath(String allowedKeyPath) {
        this.endpoint.setAllowedKeyPath(allowedKeyPath);
        return this;
    }

    public SshServerBuilder messageConverter(SshMessageConverter messageConverter) {
        this.endpoint.setMessageConverter(messageConverter);
        return this;
    }

    public SshServerBuilder marshaller(SshMarshaller marshaller) {
        this.endpoint.setMarshaller(marshaller);
        return this;
    }

    public SshServerBuilder pollingInterval(int pollingInterval) {
        this.endpoint.getEndpointConfiguration().setPollingInterval((long)pollingInterval);
        return this;
    }

    public SshServerBuilder endpointAdapter(EndpointAdapter endpointAdapter) {
        this.endpoint.setEndpointAdapter(endpointAdapter);
        return this;
    }

    public SshServerBuilder debugLogging(boolean enabled) {
        this.endpoint.setDebugLogging(enabled);
        return this;
    }

    public SshServerBuilder autoStart(boolean autoStart) {
        this.endpoint.setAutoStart(autoStart);
        return this;
    }
}

