/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.generate.javadsl;

import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.dsl.runner.TestRunner;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.generate.AbstractTestGenerator;
import com.consol.citrus.generate.TestGenerator;
import com.consol.citrus.generate.UnitFramework;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

public class JavaTestGenerator<T extends JavaTestGenerator>
extends AbstractTestGenerator<T> {
    private TestGenerator.GeneratorMode mode = TestGenerator.GeneratorMode.CLIENT;

    public JavaTestGenerator() {
        this.withFileExtension(".java");
    }

    @Override
    public void create() {
        if (Character.isLowerCase(this.getName().charAt(0))) {
            throw new CitrusRuntimeException("Test name must start with an uppercase letter");
        }
        this.createJavaTest();
    }

    protected void createJavaTest() {
        TypeSpec.Builder testTypeBuilder = TypeSpec.classBuilder((String)this.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(this.getJavaDoc()).addMethod(this.getTestMethod(this.getMethodName()));
        if (this.getFramework().equals((Object)UnitFramework.JUNIT5)) {
            testTypeBuilder.addAnnotation(this.getBaseExtension());
        } else {
            testTypeBuilder.superclass(this.getBaseType());
        }
        JavaFile javaFile = JavaFile.builder((String)this.getTargetPackage(), (TypeSpec)testTypeBuilder.build()).indent("    ").build();
        try {
            javaFile.writeTo(new File(this.getSrcDirectory()));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to write java class file", (Throwable)e);
        }
    }

    protected CodeBlock getJavaDoc() {
        return CodeBlock.builder().add("$L\n\n", new Object[]{Optional.ofNullable(this.getDescription()).orElse(this.getName())}).add("@author $L\n", new Object[]{this.getAuthor()}).add("@since $L\n", new Object[]{this.getCreationDate()}).build();
    }

    protected TypeName getBaseType() {
        if (this.getFramework().equals((Object)UnitFramework.TESTNG)) {
            return ClassName.get((String)"com.consol.citrus.testng", (String)"AbstractTestNGCitrusTest", (String[])new String[0]);
        }
        if (this.getFramework().equals((Object)UnitFramework.JUNIT4)) {
            return ClassName.get((String)"com.consol.citrus.junit", (String)"AbstractJUnit4CitrusTest", (String[])new String[0]);
        }
        throw new CitrusRuntimeException("Unsupported framework: " + (Object)((Object)this.getFramework()));
    }

    protected AnnotationSpec getBaseExtension() {
        return AnnotationSpec.builder((ClassName)ClassName.get((String)"org.junit.jupiter.api.extension", (String)"ExtendWith", (String[])new String[0])).addMember("value", "com.consol.citrus.junit.jupiter.CitrusBaseExtension", new Object[0]).build();
    }

    protected MethodSpec getTestMethod(String name) {
        ParameterSpec.Builder methodParamBuilder = ParameterSpec.builder(TestRunner.class, (String)"testRunner", (Modifier[])new Modifier[0]).addAnnotation(CitrusResource.class);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(this.getCitrusAnnotation()).addParameter(methodParamBuilder.build());
        Stream.of(this.getTestAnnotations()).forEach(arg_0 -> ((MethodSpec.Builder)methodBuilder).addAnnotation(arg_0));
        this.getActions().forEach(action -> methodBuilder.addCode(action).addCode("\n\n", new Object[0]));
        return methodBuilder.build();
    }

    protected AnnotationSpec getCitrusAnnotation() {
        return AnnotationSpec.builder(CitrusXmlTest.class).addMember("name", "$S", new Object[]{this.getName()}).build();
    }

    protected AnnotationSpec[] getTestAnnotations() {
        if (this.getFramework().equals((Object)UnitFramework.TESTNG)) {
            AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassName.get((String)"org.testng.annotations", (String)"Test", (String[])new String[0]));
            if (this.isDisabled()) {
                builder.addMember("enabled", "false", new Object[0]);
            }
            return new AnnotationSpec[]{builder.build()};
        }
        if (this.getFramework().equals((Object)UnitFramework.JUNIT4)) {
            AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassName.get((String)"org.junit", (String)"Test", (String[])new String[0]));
            if (this.isDisabled()) {
                return new AnnotationSpec[]{builder.build(), AnnotationSpec.builder((ClassName)ClassName.get((String)"org.junit", (String)"Ignore", (String[])new String[0])).build()};
            }
            return new AnnotationSpec[]{builder.build()};
        }
        if (this.getFramework().equals((Object)UnitFramework.JUNIT5)) {
            AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassName.get((String)"org.junit.jupiter.api", (String)"Test", (String[])new String[0]));
            if (this.isDisabled()) {
                return new AnnotationSpec[]{builder.build(), AnnotationSpec.builder((ClassName)ClassName.get((String)"org.junit.jupiter.api", (String)"Disabled", (String[])new String[0])).build()};
            }
            return new AnnotationSpec[]{builder.build()};
        }
        throw new CitrusRuntimeException("Unsupported framework: " + (Object)((Object)this.getFramework()));
    }

    protected List<CodeBlock> getActions() {
        return Collections.emptyList();
    }

    @Override
    public T withMode(TestGenerator.GeneratorMode mode) {
        this.mode = mode;
        return (T)((JavaTestGenerator)this.self);
    }

    @Override
    public String getSrcDirectory() {
        return super.getSrcDirectory() + File.separator + "java";
    }

    @Override
    public TestGenerator.GeneratorMode getMode() {
        return this.mode;
    }

    public void setMode(TestGenerator.GeneratorMode mode) {
        this.mode = mode;
    }
}

